module.exports = function (bh) {
    bh.match('dashboard', function (ctx, json) {
        var dashboard = json.dashboard;
        var widgetParams = json.widgetParams;
        var isDisplayed = widgetParams.displayTypes.network || widgetParams.displayTypes.interest;

        if (!isDisplayed) {
            return {
                elem: 'widget',
                help: json.help,
                showError: true
            };
        }

        ctx
            .js({
                dashboard: dashboard,
                widgetParams: widgetParams,
                sk: bh.lib.global['secret-key']
            })
            .content([
                {
                    elem: 'widget',
                    help: json.help
                },
                {
                    elem: 'modal',
                    mods: { hidden: 'yes' },
                    dashboard: dashboard
                },
                {

                    block: 'popup',
                    mods: { adaptive: 'yes', name: 'dashboard-top' },
                    js: {
                        directions: 'top'
                    },
                    content: [
                        { elem: 'tail' },
                        {
                            elem: 'content'
                        }
                    ]
                },
                {

                    block: 'popup',
                    mods: { adaptive: 'yes', name: 'dashboard-bottom' },
                    js: {
                        directions: 'bottom'
                    },
                    content: [
                        { elem: 'tail' },
                        {
                            elem: 'content'
                        }
                    ]
                }
            ]);
    });

    bh.match('dashboard__help-button', function (ctx) {
        ctx.content('?');
    });
};
