BEM.DOM.decl('dashboard', {
    onSetMod: {
        js: {
            inited: function () {
                this._dashboard = this.params.dashboard;
                this._defaultParams = this.params.widgetParams;

                this._container = this.elem('chart');
                this._widget = this.elem('widget');
                this._modal = this.elem('modal');
                this._modalControls = this.elem('filter');
                this._helpModal = this.findBlockInside('modal');
                this._helpButton = this.findElem('help-button');
                this._widgetContainer = this.elem('slider-wrapper');
                this._mainData = null;
                this._compareData = null;

                this._isDashboardActivated = false;

                this._getData(this._defaultParams)
                    .then(this._initWidget.bind(this))
                    .then(this._bindEvents.bind(this))
                    .fail(this._onWidgetFail.bind(this));
            }
        }
    },

    /**
     * Обработчик ошибки загрузки данных для виджета
     * @private
     */
    _onWidgetFail: function () {
        BEM.DOM.update(this._widgetContainer, BH.apply({
            block: 'dashboard',
            elem: 'widget-error'
        }));
    },

    _bindEvents: function () {
        this._widgetItems = this.elem('widget-item');

        BEM.blocks.select.on(this._modalControls, 'change', this._onControlsChange.bind(this));

        BEM.blocks['radio-button']
            .on(this._modalControls, 'change', this._onControlsChange.bind(this));

        BEM.blocks.button2.on(this._modalControls, 'click', this._onClickChangeFilters.bind(this));

        this.bindTo(this._widgetItems, 'pointerclick', this._onItemSelect.bind(this));
        this.bindTo(this.elem('close-button'), 'pointerclick', this._closeModal.bind(this));
        this.bindTo(this.elem('modal-close'), 'pointerclick', function () {
            this._helpModal.delMod('visible');
        });
    },

    /**
     * Запрос за данными по графикам
     * @private
     * @param {Object} params
     * @returns {Object}
     */
    _getData: function (params) {
        return $.ajax({
            type: 'POST',
            url: this._dashboard.requestUrl,
            headers: {
                'x-csrf-token': this.params.sk
            },
            contentType: 'application/json',
            data: JSON.stringify(params)
        });
    },

    /**
     * Инициализация виджета с каруселью и маленькими графиками
     * @private
     * @param {Object} data
     */
    _initWidget: function (data) {
        this._dashboard.tree = data.tree;
        this._dashboard.values = data.values;
        BEM.DOM.update(this._widgetContainer, BH.apply({
            block: 'dashboard',
            elem: 'widget-slider',
            dashboard: this._dashboard
        }));
    },

    /**
     * Клик по элементу карусели виджета
     * @param {Object} e
     * @private
     */
    _onItemSelect: function (e) {
        var target = $(e.currentTarget);

        if (!this._isDashboardActivated) {
            this._isDashboardActivated = true;
            BEM.blocks.metrika.reachGoal('dashboard_activated');
        }

        this._defaultParams.category = target.attr('category');
        this._filter = $.extend({}, this._defaultParams);
        this._filterTree = this._dashboard.tree[this._filter.category];

        this._mainData = this
            .findBlockInside(target, { blockName: 'chart', modName: 'type', modVal: 'widget' })
            .params.data;
        this._openModal();
        this._addControls();
        this._updateModal(this._mainData);
    },

    /**
     * Добавляет к данным последний день(фейковый) для красивого вывода графиков
     * @param {Object} data
     * @returns {Array}
     * @private
     */
    _addLastDate: function (data) {
        if (!data) {
            return;
        }
        var updatedData = data.slice();
        var lastDate = new Date(updatedData[updatedData.length - 1].date);

        updatedData.push({
            date: d3.timeFormat('%Y-%m-%e')(new Date(lastDate.setDate(lastDate.getDate() + 1))),
            percent: 0
        });

        return updatedData;
    },

    /**
     * Возвращает легенду для графика
     * @param {Object} filter
     * @returns {{title: string, category: string, other: string}}
     * @private
     */
    _getLegend: function (filter) {
        var legend = [];

        Object.keys(filter).forEach(function (key) {
            if (['type', 'category'].indexOf(key) > -1) {
                return;
            }
            legend.push(BH.lib.i18n('dashboard', key + '.' + filter[key]));
        });

        return {
            title: BH.lib.i18n('dashboard', 'type.' + filter.type),
            category: filter.category,
            other: legend.join(' | ')
        };
    },

    /**
     * Отрисовка большого графика
     * @param {Object} opts
     * @private
     */
    _renderChart: function (opts) {
        BEM.DOM.update(this._container, BH.apply({
            block: 'chart',
            mods: { type: 'modal' },
            js: opts
        }));
        this._modalChart = this.findBlockInside({
            blockName: 'chart',
            modName: 'type',
            modVal: 'modal'
        });
    },

    /* eslint-disable complexity */
    /**
     * Инициализация модального окна с графиком
     * @private
     * @param {Object} data
     * @param {Object} compareData
     */
    _updateModal: function (data, compareData) {
        this._mainData = data || this._mainData;

        var legend = this._getLegend(this._filter);

        var legendCompare = {};

        if (this._compareFilter) {
            this._compareData = compareData || this._compareData;
            legendCompare = this._getLegend(this._compareFilter);
        } else {
            this._compareData = null;
        }

        var opts = {
            type: this._filter.type,
            data: this._addLastDate(this._mainData),
            legend: {
                main: legend,
                compare: this._compareFilter && legendCompare
            },
            compareData: this._addLastDate(this._compareData)
        };

        if (!this._modalChart) {
            this._renderChart(opts);

            return;
        }

        this._modalChart.rebuild(opts);
    },
    /* eslint-enable complexity */

    /**
     * Добавление контролов фильтрации (категория-тип-страна-платформа)
     * Если указан аргумент, то добавляется группа контролов сравнения
     * @param {Boolean} comparison
     * @private
     */
    _addControls: function (comparison) {
        var content = BH.apply({
            block: 'dashboard',
            elem: 'filter-group',
            options: this._filter,
            dashboard: this._dashboard,
            tree: this._filterTree,
            comparison: comparison,
            addCompare: true
        });
        var filterGroup = this.findElem('filter-group', 'comparison', 'no');

        if (comparison || !filterGroup.length) {
            BEM.DOM.append(this._modalControls, content);
        } else {
            BEM.DOM.replace(filterGroup, content);
        }
    },

    /**
     * Обработчик клика по кнопке добавление/удаление фильтров
     * @param {Object} e
     * @private
     */
    _onClickChangeFilters: function (e) {
        var type = e.block.getMod('type');

        if (!type) {
            return;
        }

        if (type === 'add') {
            this._comparisonAddButton = e.block;
            this._addComparison();
            this._compareData = this._currentMainData || this._mainData;
            this._updateModal();

            return;
        }

        if (type === 'delete') {
            this._deleteComparison();
        }
    },

    _updateControlsState: function (data) {
        var changeComparison = this._changeComparison;

        var newFilterGroup = BH.apply({
            block: 'dashboard',
            elem: 'filter-group',
            options: changeComparison ? this._compareFilter : this._filter,
            dashboard: this._dashboard,
            comparison: changeComparison,
            tree: data.tree,
            addCompare: changeComparison || !this._compareFilter
        });

        var comparison = changeComparison ? 'yes' : 'no';

        BEM.DOM.replace(this.findElem('filter-group', 'comparison', comparison), newFilterGroup);

        if (!changeComparison) {
            this._filterTree = data.tree;
        }

        this._changeComparison = false;

        return data;
    },

    /**
     * Обработчик изменений контролов (как фильтров, так и контролов сравнения)
     * @param {Object} event
     * @private
     */
    _onControlsChange: function (event) {
        var block = event.block;
        /* eslint-disable init-declarations */
        var filter;
        var isComparison = block.hasMod('comparison');

        if (isComparison) {
            this._compareFilter[block.getMod('type')] = block.val();
            filter = this._compareFilter;
        } else {
            this._filter[block.getMod('type')] = block.val();
            filter = this._filter;
        }

        this._changeComparison = isComparison;

        this._getData(filter)
            .then(this._updateControlsState.bind(this))
            .then(function (data) {
                if (isComparison) {
                    this._updateModal(null, data.values);
                } else {
                    this._updateModal(data.values);
                    this._currentMainData = data.values;
                }
            }.bind(this));
    },

    _showError: function () {
        this._modalChart.renderMessage(BH.lib.i18n('dashboard', 'error.modal'));
    },

    _addComparison: function () {
        this._comparisonAddButton.setMod('hidden', 'yes');
        this._compareFilter = $.extend({}, this._filter);
        this._addControls(true);
    },

    _deleteComparison: function () {
        this._comparisonAddButton = this.findBlockInside({
            block: 'button2',
            modName: 'type',
            modVal: 'add'
        });

        this._comparisonAddButton.delMod('hidden');
        this._compareFilter = null;
        BEM.DOM.destruct(this.findElem('filter-group', 'comparison', 'yes'));

        this._updateModal();
    },

    _openModal: function () {
        this.setMod(this._widget, 'hidden', 'yes');
        this.delMod(this._modal, 'hidden');
    },

    _closeModal: function () {
        this._compareFilter = null;
        BEM.DOM.destruct(this.findElem('filter-group', 'comparison', 'yes'));

        this.delMod(this._widget, 'hidden');
        this.setMod(this._modal, 'hidden', 'yes');

        this._modalChart.destruct();
        this._modalChart = null;
    }
}, {
    live: function () {
        this.liveBindTo('help-button', 'pointerclick', function () {
            this._helpModal.setMod('visible', 'yes');
        });

        return false;
    }
});
