module.exports = function (bh) {
    bh.match('event-card', function (ctx, json) {
        var event = json.event;
        var url = json.url;

        ctx
            .tag('a')
            .attrs({ href: url })
            .content([
                {
                    elem: 'date-part',
                    startDate: event.start && event.start.date,
                    endDate: event.end && event.end.date
                },
                {
                    elem: 'description-part',
                    mods: { '': event.owner },
                    description: event.name,
                    owner: event.owner,
                    isOnline: event.isOnline
                }
            ]);
    });

    /* eslint-disable complexity */
    bh.match('event-card__date-part', function (ctx, json) {
        var start = bh.lib.util.getDate(json.startDate);
        var startDate = start && start.getDate();
        var startMonth = start && start.getMonth();

        if (json.endDate) {
            var end = bh.lib.util.getDate(json.endDate);
            var endDate = end.getDate();
            var endMonth = end.getMonth();
            var areSimilarMonths = startMonth === endMonth;

            endDate = start < end && endDate;

            ctx.content([
                {
                    elem: 'full-date',
                    startDate: startDate,
                    endDate: endDate,
                    startMonth: startMonth,
                    endMonth: !areSimilarMonths && endMonth,
                    areSimilarMonths: areSimilarMonths
                }
            ]);
        } else {
            ctx.content({
                elem: 'full-date',
                startDate: startDate,
                startMonth: startMonth
            });
        }
    });
    /* eslint-enable complexity */

    bh.match('event-card__full-date', function (ctx, json) {
        var startDate = json.startDate;
        var endDate = json.endDate;
        var startMonthNumber = json.startMonth;
        var endMonthNumber = json.endMonth;
        var areSimilarMonths = json.areSimilarMonths;

        if (endDate) {
            ctx.content([
                {
                    elem: 'dates',
                    startDate: startDate,
                    endDate: endDate,
                    startMonthNumber: startMonthNumber,
                    endMonthNumber: endMonthNumber,
                    areSimilarMonths: areSimilarMonths
                }
            ]);
        } else {
            ctx.content([
                {
                    elem: 'date-month',
                    date: startDate,
                    month: startMonthNumber
                }
            ]);
        }
    });

    bh.match('event-card__dates', function (ctx, json) {
        var startDate = json.startDate;
        var endDate = json.endDate;
        var startMonthNumber = json.startMonthNumber;
        var endMonthNumber = json.endMonthNumber;
        var areSimilarMonths = json.areSimilarMonths;

        if (areSimilarMonths) {
            ctx.content([
                {
                    elem: 'date',
                    content: startDate
                },
                { elem: 'date-sep' },
                {
                    elem: 'date',
                    content: endDate
                },
                {
                    elem: 'month',
                    content: bh.lib.i18n('months', 'g' + (startMonthNumber + 1))
                }
            ]);
        } else {
            ctx.content([
                {
                    elem: 'date-month',
                    date: startDate,
                    month: startMonthNumber
                },
                {
                    elem: 'date-sep',
                    mods: { months: 'different' }
                },
                {
                    elem: 'date-month',
                    date: endDate,
                    month: endMonthNumber
                }
            ]);
        }
    });

    bh.match('event-card__date-month', function (ctx, json) {
        var date = json.date;
        var month = json.month;

        ctx.content([
            {
                elem: 'date',
                content: date
            },
            {
                elem: 'month',
                content: bh.lib.i18n('months', 'g' + (month + 1))
            }
        ]);
    });

    /* eslint-disable complexity */
    bh.match('event-card__description-part', function (ctx, json) {
        var description = json.description;
        var tld = bh.lib.global.tld;
        var owner = json.owner;
        var ownerLocal = owner + '-' + tld;
        var isOnline = json.isOnline;

        ctx.content([
            {
                elem: 'description',
                content: description
            },
            {
                elem: 'event-info',
                content: [
                    owner && {
                        elem: 'owner',
                        content: [
                            bh.lib.i18n('edu', 'event-owner'),
                            bh.lib.i18n('edu', owner)
                        ].join(' '),
                        mods: {
                            '': owner,
                            'local': ownerLocal
                        }
                    },
                    isOnline && {
                        elem: 'online',
                        content: bh.lib.i18n('edu', 'online')
                    }
                ]
            }
        ]);
    });
    /* eslint-enable complexity */
};
