module.exports = function (bh) {
    'use strict';

    /* eslint-disable complexity */
    bh.match('event-info', function (ctx, json) {
        var event = json.event;
        var experts = json.experts;
        var lang = bh.lib.global.lang;
        var city = !event.isOnline && event.address &&
            (event.address[lang] || event.address.native).city;
        var isMap = !event.isOnline && city && event.map && json.mapsApi;
        var isAddress = event.address && event.address.raw;

        ctx.content([
            {
                elem: 'info',
                startDate: event.start && event.start.date,
                startTime: event.start && event.start.time,
                endDate: event.end && event.end.date,
                endTime: event.end && event.end.time,
                city: city,
                registerButton: event.registerButton
            },
            experts && experts.length ? {
                elem: 'experts',
                experts: experts,
                expertSlugToUrl: json.expertSlugToUrl
            } : null,
            {
                elem: 'text',
                mix: { block: 'html-content' },
                content: [
                    {
                        elem: 'description',
                        content: event.description
                    },
                    event.additionalText && {
                        elem: 'description',
                        content: event.additionalText
                    }
                ]
            },
            (isMap || isAddress) && {
                elem: 'map-address',
                content: [
                    isMap && {
                        elem: 'map-wrapper',
                        content: {
                            block: 'map',
                            js: {
                                mapsApi: json.mapsApi.yandex,
                                address: event.map
                            }
                        }
                    },
                    isAddress && {
                        elem: 'address',
                        content: event.address.raw
                    }
                ]
            },
            event.og && {
                elem: 'share',
                og: event.og
            }
        ]);
    });
    /* eslint-enable complexity */

    bh.match('event-info__info', function (ctx, json) {
        var city = json.city;
        var registerButton = json.registerButton;

        ctx.content([
            registerButton && {
                elem: 'register',
                content: {
                    elem: 'register-button',
                    content: {
                        block: 'button2',
                        mods: {
                            theme: 'action',
                            type: 'link',
                            size: 'm',
                            width: 'max',
                            vertical: 'middle'
                        },
                        text: registerButton.text,
                        url: registerButton.url
                    }
                }
            },
            {
                elem: 'full-date',
                startDate: json.startDate,
                startTime: json.startTime,
                endDate: json.endDate,
                endTime: json.endTime
            },
            {
                elem: 'city',
                content: city || bh.lib.i18n('edu', 'online')
            }
        ]);
    });

    /* eslint-disable complexity */
    bh.match('event-info__full-date', function (ctx, json) {
        var startDate = bh.lib.util.getDate(json.startDate);
        var endDate = bh.lib.util.getDate(json.endDate);
        var areSimilarMonths = startDate && endDate &&
            startDate.getMonth() === endDate.getMonth() &&
            startDate.getDate() !== endDate.getDate();

        endDate = startDate && endDate && startDate < endDate && endDate;

        ctx.content([
            {
                elem: 'dates',
                content: [
                    {
                        elem: 'date',
                        date: startDate,
                        areSimilarMonths: areSimilarMonths
                    },
                    endDate && [
                        { elem: 'date-sep' },
                        {
                            elem: 'date',
                            date: endDate
                        }
                    ]
                ]
            },
            (json.startTime || json.endTime) && {
                elem: 'time',
                startTime: json.startTime,
                endTime: json.endTime
            }
        ]);
    });
    /* eslint-enable complexity */

    bh.match('event-info__date', function (ctx, json) {
        var date = json.date;
        var monthNumber = date && date.getMonth() + 1;
        var month = json.areSimilarMonths ? '' : ' ' + bh.lib.i18n('months', 'g' + monthNumber);

        ctx.content(date.getDate() + month);
    });

    bh.match('event-info__time', function (ctx, json) {
        var start = json.startTime;
        var end = json.endTime;

        if (!start) {
            return;
        }

        ctx.content(end ? [start, ' - ', end] : [bh.lib.i18n('edu', 'starts.at'), ' ', start]);
    });

    bh.match('event-info__experts', function (ctx, json) {
        var experts = json.experts;
        var expertSlugToUrl = json.expertSlugToUrl;

        ctx.content(experts && experts.map(function (expert) {
            return {
                elem: 'expert',
                mods: !expert.isYandexSpeaker && { 'yandex-speaker': 'no' },
                name: expert.name,
                post: expert.post,
                photo: expert.smallPhoto,
                url: !expert.isYandexSpeaker && expertSlugToUrl[expert.slug]
            };
        }));
    });

    bh.match('event-info__expert', function (ctx, json) {
        var name = json.name;

        ctx
            .tag('a')
            .attrs({ href: json.url })
            .content([
                {
                    elem: 'expert-photo',
                    content: {
                        elem: 'img',
                        tag: 'img',
                        attrs: {
                            alt: name,
                            title: name,
                            src: json.photo
                        }
                    }
                },
                {
                    elem: 'expert-info',
                    content: [
                        {
                            elem: 'expert-name',
                            content: name
                        },
                        {
                            elem: 'expert-post',
                            content: json.post
                        }
                    ]
                }
            ]);
    });

    bh.match('event-info__share', function (ctx, json) {
        var ogData = json.og;

        /* eslint-disable no-unused-expressions */
        ogData && ctx.content({
            block: 'share',
            ogData: ogData
        });
    });
};
