module.exports = function (bh) {
    function getDropdown(filter) {
        return {
            block: 'dropdown2',
            mods: {
                switcher: 'button2',
                theme: 'normal',
                size: 's',
                width: 'max',
                'has-tick': 'yes',
                source: filter
            },
            switcher: bh.lib.i18n('edu', filter),
            popup: {
                mix: {
                    block: 'popup2',
                    mods: { order: 'top' }
                },
                mods: { theme: 'normal' },
                directions: ['bottom-left'],
                content: ''
            }
        };
    }

    /* eslint-disable complexity */
    bh.match('events-filter', function (ctx, json) {
        var eventsSearch = json.eventsSearch;
        var hasThemes = eventsSearch.themes && eventsSearch.themes.length;
        var hasCities = eventsSearch.cities && eventsSearch.cities.length;
        var hasMonths = eventsSearch.months && eventsSearch.months.length;

        var controls = [
            hasThemes && getDropdown('themes'),
            hasCities && getDropdown('city'),
            hasMonths && getDropdown('months'),
            (hasThemes || hasCities || hasMonths) && {
                block: 'button2',
                mods: { theme: 'action', size: 's' },
                text: bh.lib.i18n('agencies', 'search')
            }
        ];

        ctx.content(controls.map(function (control) {
            return control ? {
                elem: 'col',
                content: control
            } : null;
        }));
    });
    /* eslint-enable complexity */

    bh.match('events-filter__popup-item', function (ctx, json) {
        var item = json.item;
        var name = json.name;
        var idx = json.idx;
        var isChecked = json.isChecked;

        ctx.content({
            block: 'checkbox',
            mods: {
                theme: 'normal',
                size: 's',
                checked: isChecked > -1 ? 'yes' : false
            },
            checkboxAttrs: {
                id: 'events-filter-' + name + '_' + idx,
                value: item.number || item
            },
            text: item.name || item
        });
    });
};
