BEM.DOM.decl('events-filter', {
    onSetMod: {
        js: {
            /* eslint-disable complexity */
            inited: function () {
                this._eventsFilters = this.params.eventsFilters;

                var cities = this.params.cities;
                var themes = this.params.themes;
                var months = this.params.months;

                this._cities = cities && cities.length ? cities : false;
                this._themes = themes && themes.length ? themes : false;
                this._months = months && months.length ? months.map(function (month) {
                    return {
                        name: BH.lib.i18n('months', 'n' + month),
                        number: month
                    };
                }) : false;

                this._findElems();
                this._bindEvents();
                this._fillDropdowns();
            }
            /* eslint-enable complexity */
        }
    },

    _findElems: function () {
        if (this._cities) {
            this._city = this.findBlockInside({
                block: 'dropdown2',
                modName: 'source',
                modVal: 'city'
            });

            this._citySwitcherText = this._city.getSwitcher().getText();
        }

        if (this._themes) {
            this._theme = this.findBlockInside({
                block: 'dropdown2',
                modName: 'source',
                modVal: 'themes'
            });

            this._themeSwitcherText = this._theme.getSwitcher().getText();
        }

        if (this._months) {
            this._month = this.findBlockInside({
                block: 'dropdown2',
                modName: 'source',
                modVal: 'months'
            });

            this._monthSwitcherText = this._month.getSwitcher().getText();
        }

        this._button = this.findBlockInside({
            block: 'button2',
            modName: 'theme',
            modVal: 'action'
        });
    },

    _bindEvents: function () {
        /* eslint-disable no-unused-expressions */
        this._city && this._city.on('beforeClose', this._updateCityButton.bind(this));
        this._theme && this._theme.on('beforeClose', this._updateThemeButton.bind(this));
        this._month && this._month.on('beforeClose', this._updateMonthButton.bind(this));

        this._button && this._button.on('click', this._submit.bind(this));
    },

    /* eslint-disable complexity */
    _fillDropdowns: function () {
        /* eslint-disable no-unused-expressions */
        var selectedCities = this._eventsFilters.cities || [];
        var selectedThemes = this._eventsFilters.themes || [];
        var selectedMonths = this._eventsFilters.months || [];

        this._city && this._updateDropdown({
            name: 'city',
            popup: this._city.getPopup(),
            list: this._cities,
            selected: selectedCities,
            cb: this._updateCityButton
        });

        this._theme && this._updateDropdown({
            name: 'theme',
            popup: this._theme.getPopup(),
            list: this._themes,
            selected: selectedThemes,
            cb: this._updateThemeButton
        });

        this._month && this._updateDropdown({
            name: 'month',
            popup: this._month.getPopup(),
            list: this._months,
            selected: selectedMonths,
            cb: this._updateMonthButton
        });
    },
    /* eslint-enable complexity */

    _updateDropdown: function (params) {
        var items = params.list.map(function (item, idx) {
            var isChecked = params.selected.indexOf(item.number && item.number.toString() || item);

            return {
                block: 'events-filter',
                elem: 'popup-item',
                item: item,
                name: params.name,
                idx: idx,
                isChecked: isChecked
            };
        });

        BEM.DOM.update(params.popup.domElem, BH.apply({
            block: 'events-filter',
            elem: 'popup',
            content: items
        }), params.cb, this);
    },

    _updateCityText: function (cities) {
        var button = this._city.getSwitcher();

        if (cities.length) {
            button.setText(cities.join(', '));
        } else {
            button.setText(this._citySwitcherText);
        }
    },

    _updateThemeText: function (themes) {
        var button = this._theme.getSwitcher();

        if (themes.length) {
            button.setText(themes.join(', '));
        } else {
            button.setText(this._themeSwitcherText);
        }
    },

    _updateMonthText: function (months) {
        var button = this._month.getSwitcher();

        if (months.length) {
            button.setText(months.join(', '));
        } else {
            button.setText(this._monthSwitcherText);
        }
    },

    _getCheckboxValuesInBlock: function (block, isNum) {
        var checkboxes = block.findBlocksInside('checkbox');
        var selected = [];

        checkboxes.forEach(function (checkbox) {
            if (checkbox.isChecked()) {
                return selected.push(isNum ? Number(checkbox.val()) : checkbox.val());
            }
        });

        return selected;
    },

    _getSelectedCities: function () {
        if (!this._city) {
            return [];
        }

        return this._getCheckboxValuesInBlock(this._city.getPopup());
    },

    _getSelectedThemes: function () {
        if (!this._theme) {
            return [];
        }

        return this._getCheckboxValuesInBlock(this._theme.getPopup());
    },

    _getSelectedMonths: function () {
        if (!this._month) {
            return [];
        }

        return this._getCheckboxValuesInBlock(this._month.getPopup());
    },

    _updateCityButton: function () {
        var cities = this._getSelectedCities();

        this._updateCityText(cities);
    },

    _updateThemeButton: function () {
        var themes = this._getSelectedThemes();

        this._updateThemeText(themes);
    },

    _updateMonthButton: function () {
        var months = this._getSelectedMonths();

        this._updateMonthText(months.map(function (month) {
            return BH.lib.i18n('months', 'n' + month);
        }));
    },

    _getSelectedFields: function () {
        return {
            cities: this._getSelectedCities(),
            themes: this._getSelectedThemes(),
            months: this._getSelectedMonths()
        };
    },

    _submit: function () {
        var param = $.param(this._getSelectedFields());
        var queryString = this.params.searchUrl + (param ? '?' + param : '');

        window.location = queryString;
    }
});
