module.exports = function (blocks) {
    blocks.declare('events-list', function (data) {
        var eventsData = data.eventsData;
        var events = eventsData.events;
        var eventSlugToUrl = eventsData.eventSlugToUrl;

        return {
            block: 'events-list',
            content: events.map(function (event) {

                return {
                    block: 'event-card',
                    event: event,
                    url: eventSlugToUrl[event.slug],
                    expertSlugToName: eventsData.expertSlugToName
                };
            })
        };
    });
};
