module.exports = function (bh) {
    bh.match('expert-card', function (ctx, json) {
        var expert = json.expert;
        var name = expert.name;

        ctx
            .tag('a')
            .attrs({ href: json.url })
            .content([
                {
                    elem: 'image',
                    title: name,
                    imageUrl: expert.bigPhoto
                },
                {
                    elem: 'description-part',
                    name: name,
                    city: expert.city,
                    filters: expert.filters,
                    readyToTrips: expert.readyToTrips,
                    specializations: expert.specializations,
                    readyToComeInYourCity: expert.readyToComeInYourCity
                }
            ]);
    });

    bh.match('expert-card__image', function (ctx, json) {
        var title = bh.lib.util.replaceHtmlEntities(json.title);

        ctx.content([
            {
                elem: 'img',
                tag: 'img',
                attrs: {
                    src: json.imageUrl,
                    alt: title,
                    title: title
                }
            }
        ]);
    });

    bh.match('expert-card__description-part', function (ctx, json) {
        ctx.content([
            {
                elem: 'text',
                name: json.name,
                filters: json.filters,
                specializations: json.specializations
            },
            {
                elem: 'info',
                city: json.city,
                readyToTrips: json.readyToTrips,
                readyToComeInYourCity: json.readyToComeInYourCity
            }
        ]);
    });

    bh.match('expert-card__text', function (ctx, json) {
        var specs = json.specializations;
        var specialization = specs && specs.join(', ');
        var filters = (json.filters || []).filter(function (filter) {
            return filter.showOnCard;
        });

        ctx.content([
            {
                elem: 'description-text',
                content: json.name
            },
            specialization && {
                elem: 'description-text',
                content: bh.lib.i18n('edu', 'specialization') + ': ' + specialization
            },
            filters.map(function (filter) {
                return {
                    elem: 'description-text',
                    content: bh.lib.util.placeholder('{s}: {s}',
                        filter.name, filter.values.join(', '))
                };
            })
        ]);
    });

    bh.match('expert-card__info', function (ctx, json) {
        var city = json.city;
        var readyToTrips = json.readyToTrips;
        var readyToComeInYourCity = json.readyToComeInYourCity;

        var readyToTripsKey = bh.lib.i18n('edu', 'expert.readyToTrips');
        var readyToComeInYourCityKey = bh.lib.i18n('edu', 'expert.readyToComeInYourCity');

        ctx.content([
            city && {
                elem: 'city',
                content: city
            },
            readyToTrips && {
                elem: 'additional-info',
                attrs: { title: readyToTripsKey },
                content: readyToTripsKey
            },
            readyToComeInYourCity && {
                elem: 'additional-info',
                attrs: { title: readyToComeInYourCityKey },
                content: readyToComeInYourCityKey
            }
        ]);
    });
};
