module.exports = function (bh) {
    var getCityTextGroup = function (expert) {
        var city = expert.city;

        return {
            elem: 'text-group',
            content: [
                city && {
                    elem: 'city',
                    content: bh.lib.i18n('edu', 'city') + ': ' + city
                },
                expert.readyToTrips && {
                    elem: 'additional-info',
                    content: bh.lib.i18n('edu', 'expert.readyToTrips')
                },
                expert.readyToComeInYourCity && {
                    elem: 'additional-info',
                    content: bh.lib.i18n('edu', 'expert.readyToComeInYourCity')
                }
            ]
        };
    };

    var getContactTextGroup = function (expert) {
        var email = expert.email;
        var phone = expert.phone || expert.phoneNumber;
        var company = expert.company;

        return {
            elem: 'text-group',
            content: [
                email && {
                    elem: 'email',
                    mix: { block: 'html-content' },
                    content: bh.lib.i18n('agency', 'email') + ': ' + email
                },
                phone && {
                    elem: 'phone',
                    mix: { block: 'html-content' },
                    content: bh.lib.i18n('agency', 'phone') + ': ' + phone
                },
                company && {
                    elem: 'company',
                    mix: { block: 'html-content' },
                    content: bh.lib.i18n('edu', 'company') + ': ' + company
                }
            ]
        };
    };

    /* eslint-disable complexity */
    bh.match('expert-page', function (ctx, json) {
        var expert = json.expert;
        var form = expert.contactForm;
        var label = form && form.label.replace('{{name}}', expert.name);
        var description = form && form.description.replace('{{phone}}', expert.phoneNumber);

        ctx
            .js(true)
            .content([
                {
                    elem: 'left',
                    expert: expert,
                    info: expert.info,
                    eduExpert: json.eduExpert,
                    certByYandex: json.certByYandex
                },
                {
                    elem: 'right',
                    expert: expert,
                    events: json.events,
                    filters: expert.filters,
                    searchUrl: json.searchUrl,
                    eventSlugToUrl: json.eventSlugToUrl,
                    expertSlugToName: json.expertSlugToName
                },
                expert.contactFormButton && form && !expert.linkForConnect && {
                    block: 'modal',
                    mods: {
                        theme: 'normal',
                        autoclosable: 'yes',
                        type: 'basic',
                        size: 'm',
                        'freelancers-form': 'contact'
                    },
                    content:
                        {
                            block: 'expert-page',
                            elem: 'contact-form-wrapper',
                            content: [
                                {
                                    elem: 'contact-form-title',
                                    tag: 'h2',
                                    content: label
                                },
                                {
                                    elem: 'contact-form-description',
                                    content: description
                                },
                                {
                                    block: 'adaptive-form',
                                    data: {
                                        attrs: {
                                            name: 'freelancer-form',
                                            height: '550px'
                                        },
                                        url: expert.contactFormUrl,
                                        theme: 'normal',
                                        queryParams: {
                                            to: expert.contactEmail,
                                            slug: expert.slug
                                        },
                                        params: {
                                            adaptive: true,
                                            name: 'freelancer-form',
                                            goal: 'OTPR'
                                        }
                                    }
                                }
                            ]
                        }
                },
                ctx.content()
            ], true);
    });
    /* eslint-enable complexity */

    bh.match('expert-page__plate', function (ctx, json) {
        ctx.content([
            { elem: 'plate-letter' },
            { elem: 'plate-text',
                content: [
                    {
                        elem: 'plate-main',
                        content: json.eduExpert
                    },
                    {
                        elem: 'plate-footer',
                        content: json.certByYandex
                    }
                ]
            }
        ]);
    });

    bh.match('expert-page__certificates', function (ctx, json) {
        var certificates = json.certificates;

        if (!certificates || certificates.length === 0) {
            return '';
        }

        ctx.content(certificates.map(function (certificate) {
            var lastname = certificate.lastname;
            var image = certificate.image;
            var title = bh.lib.i18n('edu', 'user.certificate', { lastname: lastname });

            return image && {
                elem: 'certificate',
                tag: 'a',
                attrs: {
                    href: bh.lib.util.placeholder('{s}{s}&lastname={s}',
                        json.verificationUrl, certificate.certId, lastname)
                },
                content: {
                    elem: 'certificate-icon',
                    tag: 'img',
                    attrs: {
                        alt: title,
                        title: title,
                        src: image
                    }
                }
            };
        }));
    });

    bh.match('expert-page__image', function (ctx, json) {
        ctx.content({
            elem: 'img',
            tag: 'img',
            attrs: { src: json.imageUrl }
        });
    });

    bh.match('expert-page__text', function (ctx, json) {
        var expert = json.expert;

        ctx.content([
            getCityTextGroup(expert),
            getContactTextGroup(expert),
            {
                elem: 'socials',
                socials: expert.socials
            }
        ]);
    });

    bh.match('expert-page__contact-button', function (ctx, json) {
        ctx.content({
            block: 'button2',
            mods: { theme: 'action', size: 'm', type: json.linkForConnect && 'link' },
            text: bh.lib.i18n('edu', 'contact'),
            url: json.linkForConnect,
            target: '_blank'
        });
    });

    bh.match('expert-page__socials', function (ctx, json) {
        var socials = json.socials;

        ctx.content(socials && socials.length ? socials.map(function (social) {
            return {
                elem: 'social',
                mix: { block: 'html-content' },
                content: {
                    block: 'link',
                    mods: { size: 'm', theme: 'black' },
                    text: social.name,
                    url: social.link
                }
            };
        }) : null);
    });

    bh.match('expert-page__filter', function (ctx, json) {
        var data = json.data;

        if (!data.name) {
            return '';
        }

        ctx.content([
            {
                elem: 'section-title',
                content: data.name
            },
            {
                elem: 'labels-list',
                labels: data.values,
                searchUrl: json.searchUrl,
                paramName: data.slug
            }
        ]);
    });

    bh.match('expert-page__specializations', function (ctx, json) {
        var specializations = json.specializations;

        if (!specializations || specializations.length === 0) {
            return '';
        }

        ctx.content([
            {
                elem: 'section-title',
                content: bh.lib.i18n('edu', 'specialization')
            },
            {
                elem: 'labels-list',
                labels: specializations,
                searchUrl: json.searchUrl,
                paramName: 'specializations'
            }
        ]);
    });

    bh.match('expert-page__work-formats', function (ctx, json) {
        var workFormats = json.workFormats;

        if (!workFormats || workFormats.length === 0) {
            return '';
        }

        ctx.content([
            {
                elem: 'section-title',
                content: bh.lib.i18n('edu', 'workFormat')
            },
            {
                elem: 'labels-list',
                labels: workFormats,
                searchUrl: json.searchUrl,
                paramName: 'workFormats'
            }
        ]);
    });

    bh.match('expert-page__labels-list', function (ctx, json) {
        var labels = json.labels;

        ctx.content(labels.map(function (label) {
            var query = {};

            query[json.paramName] = label;
            query = bh.lib.util.stringifyQuery(query);

            return {
                elem: 'label',
                tag: 'a',
                attrs: { href: json.searchUrl + '?' + query + '&filters=1' },
                content: {
                    elem: 'label-text',
                    content: label
                }
            };
        }));
    });

    bh.match('expert-page__events', function (ctx, json) {
        var events = json.events;
        var eventSlugToUrl = json.eventSlugToUrl;

        if (!events || events.length === 0) {
            return '';
        }

        ctx.content([
            {
                elem: 'section-title',
                content: bh.lib.i18n('edu', 'events')
            },
            {
                elem: 'events-list',
                content: events.map(function (event) {
                    return {
                        block: 'event-card',
                        event: event,
                        url: eventSlugToUrl[event.slug],
                        expertSlugToName: json.expertSlugToName
                    };
                })
            }
        ]);
    });

    bh.match('expert-page__reviews', function (ctx, json) {
        var reviews = json.reviews;

        if (!reviews || reviews.length === 0) {
            return '';
        }

        ctx.content([
            {
                elem: 'section-title',
                content: bh.lib.i18n('edu', 'reviews')
            },
            reviews.map(function (review) {
                return {
                    elem: 'review',
                    review: review
                };
            })
        ]);
    });

    bh.match('expert-page__review', function (ctx, json) {
        var review = json.review;

        ctx.content([
            {
                elem: 'review-text',
                content: review.text
            },
            {
                elem: 'review-author-name',
                content: review.authorName
            },
            {
                elem: 'review-author-post',
                content: review.authorPost
            }
        ]);
    });
};
