BEM.DOM.decl('expert-page', {
    onSetMod: {
        js: {
            /* eslint-disable complexity */
            inited: function () {
                var $feedbackButton = this.findElem('feedback-button');
                var feedbackButton = $feedbackButton &&
                    this.findBlockInside($feedbackButton, 'button2');

                var $contactButton = this.findElem('contact-button');
                var contactButton = $contactButton &&
                    this.findBlockInside($contactButton, 'button2');

                var freelacersModal = this.findBlockInside({
                    block: 'modal',
                    modName: 'freelancers-form',
                    modVal: 'feedback'
                });

                var contactModal = this.findBlockInside({
                    block: 'modal',
                    modName: 'freelancers-form',
                    modVal: 'contact'
                });

                if (feedbackButton && freelacersModal) {
                    feedbackButton.bindTo('pointerclick',
                        this._showForm.bind(this, freelacersModal, 'OTZYV'));
                }

                if (contactButton) {
                    contactButton.bindTo('pointerclick', function () {
                        if (contactModal) {
                            this._showForm(contactModal, 'SVYAZ');
                        } else {
                            BEM.blocks.metrika.reachGoal('SVYAZ');
                        }
                    }.bind(this));
                }
            }
        }
        /* eslint-enable complexity */
    },

    /**
     * При клике на кнопки "Связаться" и "Оставить отзыв" показываем модальное окно с формой
     * @param {Object} modal
     * @param {String} metrikaGoalId
     * @private
     */
    _showForm: function (modal, metrikaGoalId) {
        if (modal) {
            modal.setMod('visible', 'yes');
        }

        if (metrikaGoalId) {
            BEM.blocks.metrika.reachGoal(metrikaGoalId);
        }
    }
});
