module.exports = function (bh) {
    function getDropdown(filter) {
        return {
            block: 'dropdown2',
            mods: {
                switcher: 'button2',
                theme: 'normal',
                size: 's',
                width: 'max',
                'has-tick': 'yes',
                source: filter
            },
            switcher: bh.lib.i18n('edu', filter),
            popup: {
                mix: {
                    block: 'popup2',
                    mods: { order: 'top' }
                },
                mods: { theme: 'normal' },
                directions: ['bottom-left'],
                content: ''
            }
        };
    }

    /* eslint-disable complexity */
    bh.match('experts-filter', function (ctx, json) {
        var expertsSearch = json.expertsSearch;
        var hasCities = expertsSearch.cities && expertsSearch.cities.length;
        var hasSpecializations = expertsSearch.specializations &&
            expertsSearch.specializations.length;

        var controls = [
            hasCities && getDropdown('city'),
            hasSpecializations && getDropdown('specialization'),
            (hasCities || hasSpecializations) && {
                block: 'button2',
                mods: { theme: 'action', size: 's' },
                text: bh.lib.i18n('agencies', 'search')
            }
        ];

        ctx.content(controls.map(function (control) {
            return control ? {
                elem: 'col',
                content: control
            } : null;
        }));
    });
    /* eslint-enable complexity */

    bh.match('experts-filter__popup-item', function (ctx, json) {
        var item = json.item;
        var name = json.name;
        var idx = json.idx;
        var isChecked = json.isChecked;

        ctx.content({
            block: 'checkbox',
            mods: {
                theme: 'normal',
                size: 's',
                checked: isChecked > -1 ? 'yes' : false
            },
            checkboxAttrs: {
                id: 'experts-filter-' + name + '_' + idx,
                value: item.number || item
            },
            text: item.name || item
        });
    });
};
