BEM.DOM.decl('experts-filter', {
    onSetMod: {
        js: {
            /* eslint-disable complexity */
            inited: function () {
                this._expertsFilters = this.params.expertsFilters;

                var cities = this.params.cities;
                var specializations = this.params.specializations;

                this._cities = cities && cities.length ? cities : false;
                this._specializations = specializations && specializations.length ?
                    specializations : false;

                this._findElems();
                this._bindEvents();
                this._fillDropdowns();

                if (this.params.scrollToFilters) {
                    this._scrollToFilters();
                }
            }
            /* eslint-enable complexity */
        }
    },

    _findElems: function () {
        if (this._cities) {
            this._city = this.findBlockInside({
                block: 'dropdown2',
                modName: 'source',
                modVal: 'city'
            });

            this._citySwitcherText = this._city.getSwitcher().getText();
        }

        if (this._specializations) {
            this._specialization = this.findBlockInside({
                block: 'dropdown2',
                modName: 'source',
                modVal: 'specialization'
            });

            this._specializationSwitcherText = this._specialization.getSwitcher().getText();
        }

        this._button = this.findBlockInside({
            block: 'button2',
            modName: 'theme',
            modVal: 'action'
        });
    },

    _bindEvents: function () {
        /* eslint-disable no-unused-expressions */
        this._city && this._city.on('beforeClose', this._updateCityButton.bind(this));
        this._specialization && this._specialization
            .on('beforeClose', this._updateSpecializationButton.bind(this));

        this._button && this._button.on('click', this._submit.bind(this));
    },

    _fillDropdowns: function () {
        /* eslint-disable no-unused-expressions */
        var selectedCities = this._expertsFilters.cities || [];
        var selectedSpecializations = this._expertsFilters.specializations || [];

        this._city && this._updateDropdown({
            name: 'city',
            popup: this._city.getPopup(),
            list: this._cities,
            selected: selectedCities,
            cb: this._updateCityButton
        });

        this._specialization && this._updateDropdown({
            name: 'specialization',
            popup: this._specialization.getPopup(),
            list: this._specializations,
            selected: selectedSpecializations,
            cb: this._updateSpecializationButton
        });
    },

    /**
     * Скролл до блока с фильтрацией
     * @private
     */
    _scrollToFilters: function () {
        var filters = this.findBlockInside('experts-filter');

        BEM.blocks['scroll-to'].scrollTo(filters.domElem, { offsetTop: 70 });
    },

    _updateDropdown: function (params) {
        var items = params.list.map(function (item, idx) {
            var isChecked = params.selected.indexOf(item.number && item.number.toString() || item);

            return {
                block: 'experts-filter',
                elem: 'popup-item',
                item: item,
                name: params.name,
                idx: idx,
                isChecked: isChecked
            };
        });

        BEM.DOM.update(params.popup.domElem, BH.apply({
            block: 'experts-filter',
            elem: 'popup',
            content: items
        }), params.cb, this);
    },

    _updateCityText: function (cities) {
        var button = this._city.getSwitcher();

        if (cities.length) {
            button.setText(cities.join(', '));
        } else {
            button.setText(this._citySwitcherText);
        }
    },

    _updateSpecializationText: function (specializations) {
        var button = this._specialization.getSwitcher();

        if (specializations.length) {
            button.setText(specializations.join(', '));
        } else {
            button.setText(this._specializationSwitcherText);
        }
    },

    _getCheckboxValuesInBlock: function (block, isNum) {
        var checkboxes = block.findBlocksInside('checkbox');
        var selected = [];

        checkboxes.forEach(function (checkbox) {
            if (checkbox.isChecked()) {
                return selected.push(isNum ? Number(checkbox.val()) : checkbox.val());
            }
        });

        return selected;
    },

    _getSelectedCities: function () {
        return this._getCheckboxValuesInBlock(this._city.getPopup());
    },

    _getSelectedSpecializations: function () {
        return this._getCheckboxValuesInBlock(this._specialization.getPopup());
    },

    _updateCityButton: function () {
        var cities = this._getSelectedCities();

        this._updateCityText(cities);
    },

    _updateSpecializationButton: function () {
        var specializations = this._getSelectedSpecializations();

        this._updateSpecializationText(specializations);
    },

    _getSelectedFields: function () {
        return {
            cities: this._getSelectedCities(),
            specializations: this._getSelectedSpecializations(),
            filters: 1
        };
    },

    _submit: function () {
        var param = $.param(this._getSelectedFields());

        window.location = this.params.searchUrl + (param ? '?' + param : '');
    }
});
