module.exports = function (blocks) {
    blocks.declare('experts-list', function (data) {
        var expertsData = data.expertsData;
        var experts = expertsData.experts;
        var expertSlugToUrl = expertsData.expertSlugToUrl;

        return {
            block: 'experts-list',
            content: experts
                .reduce(function (chunks, expert) {
                    var lastChunk = chunks[chunks.length - 1];
                    var expertCard = {
                        block: 'expert-card',
                        expert: expert,
                        url: expertSlugToUrl[expert.slug]
                    };

                    if (lastChunk.length < 3) {
                        lastChunk.push(expertCard);
                    } else {
                        chunks.push([expertCard]);
                    }

                    return chunks;
                }, [[]])
                .map(function (chunk) {
                    return {
                        elem: 'chunk',
                        content: chunk
                    };
                })
        };
    });
};
