module.exports = function (bh) {
    bh.match('experts-page', function (ctx, json) {
        var expertsPage = json.expertsPage;
        var title = expertsPage.title;
        var imageUrl = expertsPage.imageUrl;
        var description = expertsPage.description;
        var additionalText = expertsPage.additionalText;

        ctx
            .js({ hasFilters: json.hasFilters })
            .content([
                title && {
                    elem: 'title',
                    content: title
                },
                imageUrl && {
                    elem: 'image',
                    title: title,
                    imageUrl: imageUrl
                },
                description && {
                    elem: 'text',
                    mods: { 'font-size': 'large' },
                    content: description
                },
                {
                    elem: 'filter-anchor',
                    attrs: { id: 'filter-anchor' }
                },
                additionalText && {
                    elem: 'text',
                    content: additionalText
                }
            ]);
    });

    bh.match('experts-page__image', function (ctx, json) {
        var title = json.title;

        ctx.content([
            {
                elem: 'img',
                tag: 'img',
                attrs: {
                    src: json.imageUrl,
                    alt: title,
                    title: title
                }
            }
        ]);
    });
};
