module.exports = function (bh) {
    'use strict';
    bh.match('file-upload', function (ctx, json) {
        ctx
            .js({
                required: json.required,
                maxFilesSize: json.maxFilesSize,
                maxFilesCount: json.maxFilesCount
            })
            .content([
                {
                    block: 'attach',
                    mods: { size: 'm' },
                    content: [
                        {
                            block: 'button',
                            mods: { size: 'm', theme: 'normal' },
                            mix: [{ block: 'attach', elem: 'button' }],
                            controlAttrs: {
                                multiple: json.maxFilesCount > 1 && 'multiple'
                            },
                            name: 'file',
                            content: [
                                {
                                    block: 'image',
                                    mix: [
                                        {
                                            block: 'button',
                                            elem: 'icon',
                                            mods: {
                                                16: 'upload',
                                                theme: 'normal'
                                            }
                                        }
                                    ],
                                    alt: bh.lib.i18n('file-upload', 'upload-text')
                                },
                                bh.lib.i18n('file-upload', 'upload-text')
                            ]
                        }
                    ]
                },
                {
                    elem: 'limit',
                    content: json.tip
                },
                {
                    elem: 'message',
                    mix: {
                        block: 'input',
                        elem: 'message',
                        mods: {
                            type: 'error'
                        }
                    },
                    content: bh.lib.i18n('partners', 'form.error.required')
                }
            ]);
    });
};
