BEM.DOM.decl('file-upload', {
    onSetMod: {
        js: function () {
            var formData = new FormData();

            if (formData.fake) {
                this.destruct();

                return;
            }

            this._attached = 0;
            this._attachedSize = 0;
            this._attachButton = this.findBlockInside('attach');
            this._maxFilesSize = parseInt(this.params.maxFilesSize, 10) * 1024; // KB -> B
            this._message = this.elem('message');

            this._filesCountLimitStr = BH.lib.i18n('file-upload', 'files-limit-error', {
                count: this.params.maxFilesCount
            });

            this._filesSizeLimitStr = BH.lib.i18n('file-upload', 'size-limit-error', {
                size: this.params.maxFilesSize
            });

            this._attachButton.bindTo('change', this._onAttachChanged.bind(this));
            BEM.blocks.file.on('remove', this._removeAttached.bind(this));
        }
    },
    _onAttachChanged: function (e) {
        this._hideError();

        var fileInput = $(e.target);
        var files = Array.prototype.slice.call(fileInput.prop('files'));

        if (this._checkFilesCountLimit(files.length)) {
            this._showError(this._filesCountLimitStr);
        } else if (this._checkFilesSizeLimit(files)) {
            this._showError(this._filesSizeLimitStr);
        } else {
            files.forEach(this._createFileView.bind(this));
        }

        this._attachButton.resetFile();
    },
    _checkFilesCountLimit: function (filesCount) {
        return this._attached + filesCount > this.params.maxFilesCount;
    },
    _checkFilesSizeLimit: function (files) {
        var filesSize = 0;

        files.forEach(function (file) {
            if (file.size) {
                filesSize += file.size;
            }
        });

        return this._attachedSize + filesSize > this._maxFilesSize;
    },
    _showError: function (errorText) {
        this._message.text(errorText);
        this.setMod(this._message, 'visibility', 'visible');
        setTimeout(this._hideError.bind(this), 5000);
    },
    _hideError: function () {
        this.delMod(this._message, 'visibility');
        this._message.text(this.params.required ?
            BH.lib.i18n('partners', 'form.error.required') :
            '');
    },
    _getFileList: function () {
        var fileList = this.findElem('file-list');

        if (!fileList.length) {
            BEM.DOM.prepend(this.domElem, BH.apply({
                block: 'file-upload',
                elem: 'file-list'
            }));

            fileList = this.findElem('file-list');
        }

        return fileList;
    },
    _createFileView: function (file) {
        var timestamp = Number(new Date()).toString();
        var fileSize = file.size || 0;
        var fileList = this._getFileList();
        var fileAttrs = this.fileAttrs || {};

        fileAttrs.name = file.name;

        var fileHTML = BH.apply({
            block: 'file',
            mods: { timestamp: timestamp },
            fileAttrs: fileAttrs
        });

        BEM.DOM.append(fileList, fileHTML);

        this._attached += 1;
        this._attachedSize += fileSize;

        this.findBlockInside({ block: 'file', modName: 'timestamp', modVal: timestamp })
            .setData(file);
    },
    _removeAttached: function (e) {
        var file = e.target;

        this._attached -= 1;
        this._attachedSize -= file.size;

        if (!this._attached) {
            this._getFileList().remove();
        }
    },
    val: function () {
        var fileList = this.findBlocksInside('file-list', 'file');
        var val = [];

        fileList.forEach(function (file) {
            val.push(file.val());
        });

        return val;
    }
});
