module.exports = function (bh) {
    'use strict';
    bh.match('file', function (ctx, json) {
        var fileAttrs = json.fileAttrs || {};
        var size = fileAttrs.size || 's';
        var name = fileAttrs.name || '';

        ctx
            .js({
                fileAttrs: fileAttrs
            })
            .content([
                {
                    block: 'button',
                    mods: { size: size, side: 'left', active: 'no', theme: 'normal' },
                    content: name.length > 20 ? name.substr(0, 20) + '…' : name,
                    attrs: {
                        title: name
                    }
                },
                {
                    block: 'button',
                    mods: {
                        size: size,
                        side: 'right',
                        'only-icon': 'yes',
                        theme: 'normal'
                    },
                    mix: [
                        {
                            block: 'file',
                            elem: 'delete'
                        }
                    ],
                    content: {
                        block: 'image',
                        mix: [
                            {
                                block: 'button',
                                elem: 'icon',
                                mods: {
                                    10: 'delete',
                                    theme: 'normal'
                                }
                            }
                        ],
                        alt: ''
                    }
                }
            ]);
    });
};
