module.exports = function (bh) {
    bh.match('filters', function (ctx, json) {
        var size = json.size || 's';
        var items = json.items;

        if (!items || items.length === 0) {
            return '';
        }

        ctx
            .js({
                searchUrl: json.searchUrl,
                scrollToFilters: json.scrollToFilters
            })
            .attr('role', 'search')
            .content([
                items.map(function (filter) {
                    if (!filter) {
                        return '';
                    }

                    return {
                        elem: 'filter',
                        data: filter,
                        size: size
                    };
                }),
                {
                    elem: 'button',
                    content: {
                        block: 'button2',
                        mods: { size: size, theme: 'action' },
                        text: bh.lib.i18n('agencies', 'search')
                    }
                }
            ]);
    });

    bh.match('filters__filter', function (ctx, json) {
        var filter = json.data;
        var size = json.size || 's';
        var values = filter && filter.values;

        if (!values || values.length === 0) {
            return '';
        }

        var checkedValues = values
            .filter(function (value) {
                return value.checked;
            })
            .map(function (value) {
                return value.name;
            })
            .join(', ');

        ctx.content({
            block: 'dropdown2',
            mods: {
                switcher: 'button2',
                theme: 'normal',
                size: size,
                width: 'max',
                'has-tick': 'yes'
            },
            attrs: {
                'data-slug': filter.slug,
                'data-name': filter.name
            },
            switcher: checkedValues || filter.name,
            popup: {
                mods: { theme: 'normal' },
                mix: [
                    {
                        block: 'filters',
                        elem: 'popup'
                    },
                    {
                        block: 'popup2',
                        mods: { order: 'top' }
                    }
                ],
                directions: ['bottom-left'],
                content: {
                    block: 'filters',
                    elem: 'popup-items',
                    content: values.map(function (value) {
                        if (!value) {
                            return '';
                        }

                        return {
                            elem: 'popup-item',
                            content: {
                                block: 'checkbox',
                                mods: {
                                    size: size,
                                    theme: 'normal',
                                    checked: value.checked ? 'yes' : false
                                },
                                attrs: {
                                    'data-slug': filter.slug,
                                    'data-goal': filter.metrikaGoalId,
                                    'data-value': value.slug ? value.slug : value.name,
                                    'data-name': value.name
                                },
                                text: value.name
                            }
                        };
                    })
                }
            }
        });
    });
};
