BEM.DOM.decl('filters', {
    onSetMod: {
        js: {
            inited: function () {
                this._searchUrl = BH.lib.util.placeholder('{s}?', this.params.searchUrl);

                this._findElems();

                var button = this.findBlockInside(this.findElem('button'), 'button2');

                this.bindTo(button.domElem, 'pointerclick', this._onButtonClick.bind(this));

                if (this.params.scrollToFilters) {
                    var filters = this.findBlockInside('filters');

                    BEM.blocks['scroll-to'].scrollTo(filters.domElem, { offsetTop: 70 });
                }

                this.__self.accumulate = this.accumulateFilters;
                this.__self._checkboxes = this._checkboxes;
            }
        }
    },

    /**
     * Находит и сохраняет элементы блока
     * @private
     */
    _findElems: function () {
        this._dropdowns = this.findBlocksInside('dropdown2');
        this._checkboxes = this.findBlocksInside('checkbox');

        this._checkboxes.forEach(function (checkbox) {
            this.bindTo(checkbox.domElem, 'change',
                this._onCheckboxChange.bind(this, checkbox));
        }, this);
    },

    /**
     * Собирает выбранные значения фильтров
     * @returns {Object}
     * @private
     */
    accumulateFilters: function () {
        var checkboxes = this._checkboxes || [];

        return checkboxes.reduce(function (acc, checkbox) {
            if (!checkbox.isChecked()) {
                return acc;
            }

            var $checkbox = checkbox.domElem;
            var slug = $checkbox.data('slug');
            var value = encodeURIComponent($checkbox.data('value'));

            if (!acc[slug]) {
                acc[slug] = [];
            }

            acc[slug].push(value);

            return acc;
        }, {});
    },

    /**
     * Обработчик клика по кнопке
     * @private
     */
    _onButtonClick: function () {
        var filters = this.accumulateFilters();

        var query = Object.keys(filters)
            .reduce(function (acc, key) {
                var values = filters[key].reduce(function (valAcc, value) {
                    return valAcc + key + '=' + value + '&';
                }, '');

                return acc + values;
            }, '');

        query = query + 'filters=1';

        window.location.href = BH.lib.util.placeholder('{s}{s}', this._searchUrl, query);
    },

    /**
     * Обработчик смены значения чекбокса
     * @param {Object} checkbox
     * @private
     */
    _onCheckboxChange: function (checkbox) {
        var slug = checkbox.domElem.data('slug');
        var goal = checkbox.domElem.data('goal');
        var dropdown = this._dropdowns.filter(function (dd) {
            return dd && dd.domElem.data('slug') === slug;
        })[0];

        if (!dropdown) {
            return;
        }

        if (goal) {
            BEM.blocks.metrika.reachGoal(goal);
        }

        this._setButtonText(dropdown, checkbox);
    },

    /**
     * Меняет текст на кнопке
     * @param {Object} dropdown
     * @param {Object} checkbox
     * @private
     */
    _setButtonText: function (dropdown, checkbox) {
        var $dropdown = dropdown.domElem;
        var defaultName = $dropdown.data('name');
        var name = checkbox.domElem.data('name').toString();
        var button = this.findBlockInside($dropdown, 'button2');
        var names = button.getText().split(', ');

        if (checkbox.isChecked()) {
            names = names.filter(function (val) {
                return val !== defaultName;
            });

            names.push(name);
        } else {
            names = names.filter(function (val) {
                return val !== name;
            });
        }

        button.setText(names.join(', ') || defaultName);
    }
});
