module.exports = function (bh) {
    bh.match('gallery', function (ctx, json) {
        var images = json.images;

        if (!images || !images.length) {
            return '';
        }

        var displayImage = images[0];

        ctx
            .js(true)
            .content([
                {
                    elem: 'display-wrapper',
                    content: {
                        tag: 'img',
                        elem: 'display',
                        attrs: {
                            alt: displayImage.alt,
                            title: displayImage.title,
                            src: displayImage.src
                        }
                    }
                },
                images.length > 1 && {
                    elem: 'controls',
                    mods: { many: images.length > 4 && 'yes' },
                    content: images.map(function (image, idx) {
                        return {
                            elem: 'image',
                            mods: { active: idx === 0 && 'yes' },
                            image: image
                        };
                    })
                }
            ]);
    });

    bh.match('gallery__image', function (ctx, json) {
        var image = json.image;

        ctx
            .tag('img')
            .attrs({
                alt: image.alt,
                title: image.title,
                src: bh.lib.util.mds(image.src, 'mainpage_journal_m'),
                'data-alt': image.alt,
                'data-title': image.title,
                'data-src': image.src
            });
    });

    bh.match('gallery__cover', function (ctx) {
        ctx.content({
            block: 'spin2',
            mods: {
                size: 'l',
                progress: 'yes'
            }
        });
    });
};
