BEM.DOM.decl('gallery', {
    onSetMod: {
        js: {
            inited: function () {
                this._displayWrapper = this.findElem('display-wrapper');
                this._display = this.findElem('display');
                this._imageIdentity = BH.lib.global.isMobile ? '.gallery__dot' : 'img';

                this.bindTo(this.domElem, 'pointerclick', this._onImageClick.bind(this));
            }
        }
    },

    _onImageClick: function (e) {
        var $image = $(e.target);

        if (!$image.is(this._imageIdentity) || $image.is(this._display)) {
            return;
        }

        this._setActive($image);
        this._runSpinner();
        this._changeAttrs($image);

        this.bindTo(this._display, 'load', function () {
            this._hideSpinner();
        }.bind(this));
    },

    _setActive: function (activeImage) {
        var currentActive = this.findElem('image', 'active', 'yes');

        this.delMod(currentActive, 'active');
        this.setMod(activeImage, 'active', 'yes');
    },

    _changeAttrs: function (image) {
        var alt = image.attr('data-alt');
        var title = image.attr('data-title');
        var src = image.attr('data-src');

        this._display.attr('alt', alt);
        this._display.attr('title', title);
        this._display.attr('src', src);
    },

    _runSpinner: function () {
        var cover = BH.apply({
            block: 'gallery',
            elem: 'cover'
        });

        if (!this._cover) {
            this._cover = $(cover);

            BEM.DOM.append(this._displayWrapper, this._cover);
        }
    },

    _hideSpinner: function () {
        if (this._cover) {
            BEM.DOM.destruct(this._cover);
        }
    }
});
