module.exports = function (bh) {
    'use strict';
    bh.match('horizontal-select', function (ctx, json) {
        var data = json.data;
        var items = data.items;
        var selectedItem = data.selectedItem || 0;

        ctx
            .js({
                selectedItem: selectedItem
            })
            .content([
                {
                    elem: 'blur',
                    mods: {
                        position: 'left'
                    },
                    attrs: { style: 'opacity: 0;' }
                },
                {
                    elem: 'blur',
                    mods: {
                        position: 'right'
                    }
                },
                {
                    elem: 'scroll-container',
                    content: {
                        elem: 'item-container',
                        content: items.map(function (item, index) {
                            var selected = index === selectedItem;

                            return {
                                elem: 'item',
                                mods: { selected: selected },
                                content: item
                            };
                        })
                    }
                }
            ]);
    });

    bh.match('horizontal-select__item', function (ctx, json) {
        var item = json.item;

        /* eslint-disable no-unused-expressions */
        ctx
            .tag('button')
            .content({
                content: item
            });
    });
};
