BEM.DOM.decl('horizontal-select', {
    onSetMod: {
        js: {
            inited: function () {
                this._findElems();

                this._isMoving = false;
                this._prevX = null;
                // На сколько пикселей двигался курсор пользователя после начала касания
                // Если не больше чем _maxMovingPathLength – касание считаем как клик
                this._movingPathLength = 0;
                this._maxMovingPathLength = 4;

                this._updateBlurs(0);

                this.selectByIndex(this.params.selectedItem, false);

                this.bindTo(this._scrollWrapper, 'scroll', this._onScroll.bind(this));

                this.selectByIndex = this.selectByIndex.bind(this);
                this.onSelectChanged = this.onSelectChanged.bind(this);
            }
        }
    },

    _findElems: function() {
        this._scrollWrapper = this.findElem('scroll-container');
        this._itemWrapper = this.findElem('item-container');
        this._leftBlur = this.findElem('blur')[0];
        this._rightBlur = this.findElem('blur')[1];
    },

    onSelectChanged: function(callback) {
        this._onSelectChangedHandler = callback;
    },

    selectByIndex: function(selectedIndex, needDispatchEvent) {
        var predicate = function(item, index) {
            return selectedIndex === index;
        };

        this._selectWithPredicate(predicate, needDispatchEvent);
    },

    select: function(selectedItem, needDispatchEvent) {
        var predicate = function(item) {
            return selectedItem === item;
        };

        this._selectWithPredicate(predicate, needDispatchEvent);
    },

    _selectWithPredicate: function(predicate, needDispatchEvent) {
        var children = this._itemWrapper.children();

        for (var i = 0; i < children.length; i += 1) {
            var child = children[i];
            var isSelected = predicate(child, i);

            this._selectItem(child, i, isSelected);

            if (isSelected && needDispatchEvent) {
                var event = this._createChangedEvent(child, i);

                this._dispatchChangedEvent(event);
            }
        }
    },


    _selectItem: function(item, index, isSelected) {
        var $elem = $(item);

        this.setMod($elem, 'selected', isSelected);

        if (isSelected) {
            this._moveElementToVisibleArea($elem, index);
        }
    },


    _dispatchChangedEvent: function(event) {
        if (this._onSelectChangedHandler) {
            this._onSelectChangedHandler(event);
        }
    },


    _onScroll: function() {
        this._updateBlurs(this._scrollWrapper.scrollLeft());
    },

    _dragStart: function(startX) {
        this._isMoving = true;
        this._prevX = startX;
    },

    _drag: function(x) {
        if (this._isMoving) {
            var offset = x - this._prevX;

            this._movingPathLength += Math.abs(offset);
            this._prevX = x;

            this._scrollBy(offset);
        }
    },

    _dragEnd: function(event) {
        if (this._isMoving) {
            event.preventDefault();
            event.stopPropagation();
        }

        var isButtonPressed = event.target.tagName === 'BUTTON';

        if (this._movingPathLength < this._maxMovingPathLength && isButtonPressed) {
            this.select(event.target, true);
        }

        this._cancelScrolling(event);
    },

    _cancelScrolling: function(event) {
        this._movingPathLength = 0;
        this._isMoving = false;
        this._prevX = null;

        event.target.blur();
    },

    _scrollBy: function(offset) {
        var multiplier = 1.2;
        var newOffset = this._scrollWrapper.scrollLeft() - multiplier * offset;

        this._scrollWrapper.scrollLeft(newOffset);
    },

    _moveElementToVisibleArea: function($element, index) {
        var position = {
            left: $element.position().left,
            right: $element.position().left + $element.outerWidth(true)
        };
        var currentScrollLeft = this._scrollWrapper.scrollLeft();
        var width = this._scrollWrapper.width();

        var duration = 200;

        if (position.left < 0 || position.right > this._scrollWrapper.width()) {
            var offset = this._calcScrollOffset(position, width, index);

            var newScrollLeft = currentScrollLeft + offset;

            this._scrollWrapper.animate({ scrollLeft: newScrollLeft }, duration);
        }
    },

    _updateBlurs: function(offset) {
        // Сдвиг в px, при котором блюр должен стать полностью видимым
        var fullVisibilityOffset = 10;
        var maxOffset = this._itemWrapper.width() - this._scrollWrapper.width();

        var leftBlurOpacity = offset / fullVisibilityOffset;
        var rightBlurOpacity = (maxOffset - offset) / fullVisibilityOffset;

        this._setOpacity(this._leftBlur, leftBlurOpacity);
        this._setOpacity(this._rightBlur, rightBlurOpacity);
    },

    _setOpacity: function(element, opacity) {
        $(element).css('opacity', opacity);
    },

    _createChangedEvent: function(item, index) {
        return {
            type: 'horizontal.select.changed',
            item: {
                value: item,
                index: index
            }
        };
    }
});
