BEM.DOM.decl('iframe-form', {
    onSetMod: {
        js: {
            inited: function () {
                this._iframe = this.domElem;

                this.bindToWin('message', this._onIframeMessage.bind(this));
            }
        }
    },

    /* eslint-disable complexity */
    _onIframeMessage: function (e) {
        var data = e.originalEvent.data;

        try {
            data = JSON.parse(data);
        } catch (err) {
            return;
        }

        var source = e.originalEvent.source;

        /* eslint-disable max-len */
        // Iframe anti ClickJacking
        // https://github.yandex-team.ru/pages/yandex-events/yandex-tech-api-docs/docs.html#vstraivanie-formyi-v-iframe
        if (data === 'ping' || data.message === 'ping') {
            source.postMessage('pong', '*');
        }

        // Через postMessage с интервалом в 300мс отправляется высота страницы
        // Меняем высоту iframe
        if (data['iframe-height'] && data.name === this._iframe.attr('name')) {
            this._iframe.height(data['iframe-height']);
        }
    }
    /* eslint-enable complexity */
});
