module.exports = function (bh) {
    bh.match('image-pins', function (ctx, json) {
        if (!json.pinsData) {
            return '';
        }

        ctx
            .js({ goalId: json.metrikaGoalId })
            .tag('section')
            .tParam('pinsData', json.pinsData)
            .content([
                { elem: 'wrapper' },
                ctx.content()
            ], true);
    });

    bh.match('image-pins__wrapper', function (ctx) {
        var pinsData = ctx.tParam('pinsData');

        ctx.content([
            { elem: 'image' },
            pinsData.pins
                .slice()
                .reverse()
                .map(function (pin, index) {
                    return {
                        elem: 'pin',
                        pin: pin,
                        index: index
                    };
                }),
            ctx.content()
        ], true);
    });

    bh.match('image-pins__data', function (ctx) {
        ctx.mix({ block: 'html-content' });
    });

    bh.match('image-pins__image', function (ctx) {
        ctx
            .tag('img')
            .attr('src', ctx.tParam('pinsData').image);
    });

    bh.match('image-pins__pin', function (ctx, json) {
        ctx
            .attrs({
                'data-title': json.pin.title,
                'data-text': json.pin.text,
                'data-index': json.index,
                style: bh.lib.util.placeholder(
                    'left: {s}; top: {s};',
                    json.pin.coords.left,
                    json.pin.coords.top
                )
            })
            .content([
                { elem: 'pin-base' },
                {
                    elem: 'pin-label',
                    content: json.pin.label
                }
            ]);
    });

    bh.match('image-pins__info', function (ctx, json) {
        ctx.content([
            json.title && {
                elem: 'info-title',
                content: json.title
            },
            {
                elem: 'info-text',
                content: json.text
            },
            json.pinsCount > 1 && {
                elem: 'info-arrows'
            }
        ]);
    });

    bh.match('image-pins__info-arrows', function (ctx) {
        var buttonMods = { theme: 'clear', size: 'm', view: 'classic', tone: 'default' };

        ctx.content([
            {
                block: 'button2',
                mods: bh.utils.extend({ arrow: 'left' }, buttonMods),
                icon: {
                    mods: {
                        type: 'arrow',
                        direction: 'left'
                    }
                }
            },
            {
                block: 'button2',
                mods: bh.utils.extend({ arrow: 'right' }, buttonMods),
                icon: {
                    mods: {
                        type: 'arrow',
                        direction: 'right'
                    }
                }
            }
        ]);
    });
};
