BEM.DOM.decl('image-pins', {
    onSetMod: {
        js: function () {
            this._pins = this.elem('pin');
            this._data = this.elem('data');
            this._currentIndex = -1;

            this.bindTo(this._pins, 'pointerclick', this._onPinClick.bind(this));
            BEM.blocks.button2.on(this._data, 'click', this._onArrowClick.bind(this));
        }
    },

    _onPinClick: function (e) {
        var $pin = $(e.currentTarget);

        this._showInfo($pin, {
            title: $pin.data('title'),
            text: $pin.data('text'),
            index: $pin.data('index')
        });

        if (this.params.goalId) {
            BEM.blocks.metrika.reachGoal(this.params.goalId);
        }
    },

    _showInfo: function (anchor, options) {
        if (this._currentIndex > -1) {
            this._setPinVisited(this._findPinByIndex(this._currentIndex));
        }

        this._info = BH.apply({
            block: this.constructor.getName(),
            elem: 'info',
            title: options.title,
            text: options.text,
            pinsCount: this._pins.length
        });

        this._currentIndex = options.index;

        this._data.html(this._info);
        this._setPinActive(anchor);
    },

    _findPinByIndex: function (index) {
        for (var i = 0; i < this._pins.length; i += 1) {
            var $pin = $(this._pins[i]);

            if (parseInt($pin.data('index'), 10) === index) {
                return $pin;
            }
        }
    },

    /* eslint-disable complexity */
    _onArrowClick: function (e) {
        var direction = e.block.getMod('arrow');
        var index = 0;

        if (direction === 'left') {
            index = this._currentIndex === 0 ? this._pins.length - 1 : this._currentIndex - 1;
        } else if (direction === 'right') {
            index = this._currentIndex === this._pins.length - 1 ? 0 : this._currentIndex + 1;
        }

        var $pin = this._findPinByIndex(index);

        if (!$pin) {
            return;
        }

        this._showInfo($pin, {
            title: $pin.data('title'),
            text: $pin.data('text'),
            index: $pin.data('index')
        });
    },
    /* eslint-enable complexity */

    _setPinActive: function (anchor) {
        this.setMod(anchor, 'active', true);
    },

    _setPinVisited: function (anchor) {
        this.delMod(anchor, 'active');
        this.setMod(anchor, 'visited', true);
    }
});
