module.exports = function (bh) {
    bh.match('journals', function (ctx, json) {
        var journalData = getJournalData(json.data);

        ctx
            .js({
                count: json.items.length,
                filterUrl: json.filterUrl,
                more: json.data.more,
                journalData: journalData
            })
            .content([
                {
                    elem: 'list',
                    content: json.items.map(function (journal) {
                        return {
                            elem: 'level',
                            level: journal,
                            data: journalData
                        };
                    })
                },
                { block: 'notifications-list' }
            ]);
    });

    bh.match('journals__level', function (ctx, json) {
        var level = json.level || {};
        var data = json.data || {};

        return {
            block: 'level',
            mods: { type: 'journal' },
            url: data.url,
            level: level,
            page: data.page,
            comdiUrl: data.comdiUrl,
            newsPage: data.newsPage,
            browserName: data.browserName,
            commentsData: data.commentsData,
            journalsPage: data.journalsPage,
            isBrowserValid: data.isBrowserValid,
            transactionPath: data.transactionPath
        };
    });

    bh.match('journals__spinner', function (ctx) {
        ctx.content({
            block: 'spin2',
            mods: {
                size: 'l',
                progress: 'yes'
            }
        });
    });

    function getJournalData(data) {
        data = data || {};

        return {
            url: data.url,
            page: data.page,
            comdiUrl: data.comdiUrl,
            newsPage: data.newsPage,
            browserName: data.browserName,
            commentsData: data.commentsData,
            journalsPage: data.journalsPage,
            isBrowserValid: data.isBrowserValid,
            transactionPath: data.transactionPath
        };
    }
};
