BEM.DOM.decl('journals', {
    onSetMod: {
        js: {
            inited: function () {
                this._button = this.findElem('button');
                this._list = this.findElem('list');

                this._more = this.params.more;
                this._count = this.params.count;
                this._lockServer = false;

                this._scrollHandler = $.debounce(this._onScroll.bind(this), 300);

                this.bindToWin('scroll', this._scrollHandler);
            }
        }
    },

    /**
     * При скролле загружаем новые данные
     * @private
     */
    _onScroll: function () {
        if (!this._more) {
            this.unbindFromWin('scroll', this._scrollHandler);

            return;
        }

        var winBottom = window.pageYOffset + window.innerHeight;
        var listBottom = this._list.offset().top + this._list.height();

        if (winBottom > listBottom) {
            this._showSpinner();
            this._request();
        }
    },

    /**
     * Показать спиннер
     * @private
     */
    _showSpinner: function () {
        if (this._spinner) {
            return;
        }

        this._spinner = $(BH.apply({
            block: 'journals',
            elem: 'spinner'
        }));

        BEM.DOM.append(this.domElem, this._spinner);
    },

    /**
     * Скрыть спиннер
     * @private
     */
    _hideSpinner: function () {
        if (this._spinner) {
            BEM.DOM.destruct(this._spinner);

            this._spinner = null;
        }
    },

    /**
     * Запрос за данными
     * @private
     */
    _request: function () {
        if (this._lockServer) {
            return;
        }

        this._lockServer = true;

        var data = BEM.blocks.filters.accumulate();

        data.startIdx = this._count;

        var options = {
            type: 'POST',
            url: this.params.filterUrl,
            contentType: 'application/json',
            data: JSON.stringify(data)
        };

        $.ajax(options)
            .done(this._appendList.bind(this))
            .fail(this._showError.bind(this))
            .always(function () {
                this._lockServer = false;
                this._hideSpinner();
            }.bind(this));
    },

    /**
     * При корректном ответе сервера меняем данные в списке
     * @param {{ list: Object[], lastIdx: Number, more: Boolean }} data
     * @returns {*}
     * @private
     */
    _appendList: function (data) {
        if (!data || !Array.isArray(data.list)) {
            return this._showError();
        }

        this._more = data.more;

        var list = data.list || [];
        var items = list.reduce(function (html, item) {
            return html + BH.apply({
                block: 'journals',
                elem: 'level',
                level: item,
                data: this.params.journalData
            });
        }.bind(this), '');

        BEM.DOM.append(this._list, items);

        this._count += list.length;
    },

    /**
     * Показать сообщение об ошибке
     * @private
     */
    _showError: function () {
        var message = BH.lib.i18n('common', 'more.button.error');

        BEM.blocks['notifications-list'].notify(message);
    }
});
