module.exports = function (bh) {
    /* eslint-disable init-declarations */
    var relations = {}; // Отношения между узлами меню
    var currentNode; // Текущий (активный) элемент меню

    /**
     * Построение дерева отношений меню
     * @param {Object} node
     * @param {Object|*} from
     * @param {Object} relationsObj
     */
    function buildMenuRelations(node, from, relationsObj) {
        node.from = from.id;
        relationsObj[node.id] = node;

        if (node.isCurrent) {
            currentNode = node.id;

            return;
        }

        if (Array.isArray(node.content)) {
            node.content.forEach(function (element) {
                buildMenuRelations(element, node, relationsObj);
            });
        }
    }

    /**
     * Выставляет состояние `opened` всем родительским узлам текущего элемента
     * @param {Number} id
     */
    function spreadNode(id) {
        var node = relations[id];

        if (node) {
            if (node.elem === 'node') {
                node.mods = { opened: 'yes' };
            }
            if (node.from) {
                spreadNode(node.from);
            }
        }
    }

    bh.match('left-menu', function (ctx) {
        var menu = ctx.param('data').menu;
        var menuTitle = ctx.param('data').title;

        if (!Array.isArray(menu)) {
            return '';
        }

        menu.forEach(function (element) {
            buildMenuRelations(element, {}, relations);
        });

        if (currentNode) {
            spreadNode(currentNode);
        }

        ctx
            .js(true)
            .content([
                menuTitle && {
                    elem: 'menu-title',
                    content: menuTitle
                },
                {
                    elem: 'menu',
                    content: menu
                }
            ]);
    });

    bh.match('left-menu__menu', function (ctx) {
        ctx
            .tag('ul')
            .attr('role', 'menu');
    });

    bh.match('left-menu__leaf', function (ctx) {
        var isCurrent = ctx.param('isCurrent');
        var url = ctx.param('url');
        var content = {
            block: 'link',
            mods: { theme: isCurrent ? 'black' : 'normal' },
            url: url,
            content: ctx.param('name')
        };

        if (!url) {
            content = {
                tag: 'span',
                content: ctx.param('name')
            };
            ctx.mod('current', 'yes');
        }

        ctx
            .tag('li')
            .content(content);
    });

    bh.match('left-menu__node', function (ctx) {
        ctx.tag('li');
        ctx.content([
            {
                elem: 'node-title',
                content: ctx.param('name')
            },
            {
                tag: 'ul',
                content: ctx.content()
            }
        ], true);
    });

    bh.match('left-menu__node-title', function (ctx) {
        ctx.content([
            {
                elem: 'arrow'
            },
            ctx.content()
        ], true);
    });
};
