BEM.DOM.decl('left-menu', {

    onSetMod: {
        js: function () {
            this._nodeTitles = this.elem('node-title');

            this._bindEvents();
        }
    },

    _bindEvents: function () {
        this._nodeTitles.on('pointerclick', this._onNodeClick.bind(this));
    },

    _spreadBranch: function (node) {
        var opened = this.hasMod(node, 'opened');
        var nodes = opened ?
            node.find(this.buildSelector('node')) : node.parents(this.buildSelector('node'));

        if (opened) {
            this.delMod(nodes, 'opened');
            this.delMod(node, 'opened');
            this.domElem.trigger('change');

            return;
        }

        this.setMod(node, 'opened', 'yes');
        this.domElem.trigger('change');
    },

    _onNodeClick: function (e) {
        this._spreadBranch($(e.target.parentElement));
    }
});
