module.exports = function (bh) {
    bh.match('lesson-block_type_text-switch', function (ctx, json) {
        var data = json.data;
        var switchers = data.switchers;

        if (switchers.length === 0) {
            return '';
        }

        ctx.content([
            ctx.content(),
            switchers.map(function (switcher, idx) {
                return {
                    elem: 'option',
                    mods: { index: idx, active: idx === 0 },
                    mix: { block: 'html-content' },
                    content: switcher.text
                };
            })
        ], true);
    });
};
