module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('lesson-block_type_text', function (ctx, json) {
        var data = json.data;
        var image = data.image;
        var player = data.player;
        var youtubeID = data.video;
        var vhUrl = data.vhUrl;
        var button = data.button;
        var goalId = button && button.metrikaGoalId;
        var youtubeUrl = youtubeID && bh.lib.util.placeholder(
            'https://www.youtube-nocookie.com/embed/{s}?rel=0&amp;showinfo=0',
            youtubeID
        );

        var videoSrc = player === 'yavh' ? vhUrl : youtubeUrl;

        ctx
            .js(goalId ? { goalId: goalId } : null)
            .content([
                image && {
                    elem: 'image',
                    title: data.title,
                    image: image
                },
                videoSrc && {
                    elem: 'video',
                    content: {
                        tag: 'iframe',
                        attrs: {
                            width: 670,
                            height: 375,
                            frameborder: 0,
                            allowfullscreen: true,
                            src: videoSrc
                        }
                    }
                },
                button && button.url && {
                    elem: 'button',
                    content: {
                        block: 'button2',
                        mods: { theme: 'normal', size: 'm', type: 'link' },
                        url: button.url,
                        text: button.text
                    }
                }
            ], true);
    });
    /* eslint-enable complexity */
};
