module.exports = function (bh) {
    bh.match('lesson-block', function (ctx, json) {
        var data = json.data;

        if (!data) {
            return '';
        }

        ctx
            .tag('section')
            .attrs({ id: data.anchor })
            .content([
                data.title && {
                    elem: 'title',
                    content: data.title
                },
                data.text && {
                    elem: 'text',
                    mix: { block: 'html-content' },
                    content: bh.lib.util.template(data.text)
                },
                ctx.content()
            ], true);
    });
};
