module.exports = function (bh) {
    bh.match('lesson-cards', function (ctx, json) {
        var items = json.items;

        if (!items || !items.length) {
            return '';
        }

        ctx
            .js({ goalId: json.metrikaGoalId })
            .content(items.map(function (item) {
                return {
                    elem: 'card',
                    data: item
                };
            }));
    });

    bh.match('lesson-cards__card', function (ctx, json) {
        var data = json.data;
        var outer = data.outer;
        var inner = data.inner;

        if (!outer || !inner) {
            return '';
        }

        ctx
            .mods({ 'no-border': inner.textBackground === 'gray' })
            .content([
                {
                    elem: 'card-outer',
                    data: outer
                },
                {
                    elem: 'card-inner',
                    data: inner
                }
            ]);
    });

    /* eslint-disable complexity */
    bh.match('lesson-cards__card-outer', function (ctx, json) {
        var data = json.data;
        var text = data.text;
        var image = data.image;
        var fullScreen = data.fullScreen;
        var isHeader = data.isHeader;

        image = image && bh.lib.util.mds(image, 'news_image_m_2x');

        if (image && fullScreen) {
            ctx.attrs({ style: 'background-image: url("' + image + '");' });
        }

        ctx.content([
            image && !fullScreen && {
                elem: 'image',
                tag: 'img',
                attrs: {
                    alt: text,
                    title: text,
                    src: image
                }
            },
            fullScreen && { elem: 'overlay' },
            text && {
                elem: 'outer-text',
                mods: {
                    'full-screen': fullScreen,
                    header: isHeader,
                    single: !image
                },
                mix: { block: 'html-content' },
                content: text
            }
        ]);
    });

    bh.match('lesson-cards__card-inner', function (ctx, json) {
        var data = json.data;
        var text = data.text;
        var image = data.image;
        var hasImageBorder = data.hasImageBorder;
        var textBackground = data.textBackground;

        image = image && bh.lib.util.mds(image, 'news_image_m_2x');

        ctx
            .mods({ background: textBackground || 'white' })
            .content([
                image && {
                    elem: 'image',
                    mods: { border: hasImageBorder && 'yes' },
                    content: {
                        tag: 'img',
                        attrs: {
                            alt: text,
                            title: text,
                            src: image
                        }
                    }
                },
                text && {
                    elem: 'inner-text',
                    mods: { narrow: Boolean(image) },
                    mix: { block: 'html-content' },
                    content: text
                }
            ]);
    });
    /* eslint-enable complexity */
};
