BEM.DOM.decl('lesson-cards', {
    onSetMod: {
        js: {
            inited: function () {
                this._cards = this.elem('card');

                this.bindTo(this._cards, 'pointerclick', this._rotateCard.bind(this));
            }
        }
    },

    /**
     * При клике на карточку она становится активной,
     * остальные переворачиваются внешней стороной
     * @param {Object} e
     * @private
     */
    _rotateCard: function (e) {
        var isActive = this.hasMod(e.data.domElem, 'active', true);

        this.delMod(this._cards, 'active');

        if (!isActive) {
            this.setMod(e.data.domElem, 'active', true);
        }

        if (this.params.goalId) {
            BEM.blocks.metrika.reachGoal(this.params.goalId);
        }
    }
});
