module.exports = function (bh) {
    bh.match('lesson-content', function (ctx, json) {
        var contentText = json.contentText;
        var blocks = json.blocks;
        var hasTitles = blocks && blocks.filter(function (block) {
            return block.title;
        }).length > 0;

        if (!hasTitles) {
            return '';
        }

        var lessonContent = bh.lib.i18n('edu', 'lesson-content');

        ctx
            .js({ goalId: json.metrikaGoalId })
            .content([
                {
                    content: contentText || bh.lib.util.placeholder('{s}:', lessonContent)
                },
                blocks.map(function (block) {
                    return {
                        elem: 'link',
                        attrs: {
                            'data-anchor': bh.lib.util.placeholder('#{s}', block.anchor)
                        },
                        content: {
                            block: 'link',
                            mods: { theme: 'pseudo', pseudo: 'yes' },
                            content: block.title
                        }
                    };
                })
            ]);
    });
};
