module.exports = function (bh) {

    /**
     * Возвращает Radiobox
     * @param {Object []} items
     * @param {String} exerciseId
     * @returns {Object}
     */
    function buildRadiobox(items, exerciseId) {
        return {
            block: 'radiobox',
            mods: { size: 'm', theme: 'normal' },
            content: items.map(function (item, idx) {
                var isCorrect = item.isCorrect;
                var radioId = exerciseId + '-' + idx;

                return [
                    {
                        elem: 'radio',
                        mix: { block: 'lesson-exercise', elem: 'radio' },
                        attrs: {
                            'data-id': radioId,
                            'data-value': isCorrect ? 'correct' : 'incorrect'
                        },
                        controlAttrs: { value: radioId },
                        content: {
                            mix: [
                                { block: 'lesson-exercise', elem: 'option' },
                                { block: 'html-content' }
                            ],
                            content: item.text
                        }
                    }
                ];
            })
        };
    }

    /**
     * Возвращает Checkbox
     * @param {Object []} items
     * @param {String} exerciseId
     * @returns {Object}
     */
    function buildCheckbox(items, exerciseId) {
        return items.map(function (item, idx) {
            var value = item.isCorrect ? 'correct' : 'incorrect';

            return {
                block: 'checkbox',
                mods: { theme: 'normal', size: 's' },
                attrs: {
                    'data-id': exerciseId + '-' + idx,
                    'data-value': value
                },
                checkboxAttrs: { value: value },
                text: {
                    elem: 'label',
                    mix: [
                        { block: 'lesson-exercise', elem: 'option' },
                        { block: 'html-content' }
                    ],
                    content: item.text
                }
            };
        });
    }

    bh.match('lesson-exercise', function (ctx, json) {
        var data = json.data;
        var text = data.text;
        var image = data.image;

        ctx
            .js({ goalId: json.metrikaGoalId })
            .content([
                text && {
                    elem: 'text',
                    mix: { block: 'html-content' },
                    content: text
                },
                image && {
                    elem: 'image',
                    tag: 'img',
                    attrs: {
                        alt: text,
                        title: text,
                        src: image
                    }
                },
                {
                    elem: 'options',
                    items: data.options,
                    exerciseId: json.exerciseId
                },
                { elem: 'submit' },
                {
                    elem: 'explanation',
                    mods: { hidden: true },
                    pass: data.passExplanation,
                    part: data.partExplanation,
                    fail: data.failExplanation
                }
            ]);
    });

    bh.match('lesson-exercise__options', function (ctx, json) {
        var items = json.items;

        if (!items || items.length === 0) {
            return '';
        }

        var isRadio = items.filter(function (item) {
            return item.isCorrect;
        }).length === 1;

        var renderOptions = isRadio ? buildRadiobox : buildCheckbox;

        ctx.content(renderOptions(items, json.exerciseId));
    });

    bh.match('lesson-exercise__explanation', function (ctx, json) {
        ctx.content([
            { elem: 'success-indicator' },
            {
                elem: 'explanation-text',
                mods: { type: 'pass', hidden: true },
                mix: { block: 'html-content' },
                content: json.pass
            },
            {
                elem: 'explanation-text',
                mods: { type: 'part', hidden: true },
                mix: { block: 'html-content' },
                content: json.part
            },
            {
                elem: 'explanation-text',
                mods: { type: 'fail', hidden: true },
                mix: { block: 'html-content' },
                content: json.fail
            }
        ]);
    });
};
