BEM.DOM.decl('lesson-exercise', {
    onSetMod: {
        js: {
            inited: function () {
                this._submit = this.findBlockInside(this.findElem('submit'), 'button2');
                this._radiobox = this.findBlockInside('radiobox');
                this._radioElems = this.elem('radio');
                this._checkboxes = this.findBlocksInside('checkbox');
                this._storage = BEM.blocks['i-bem'].getStorage();

                if (this._recoverAnswers()) {
                    this._markCorrectOptions();
                } else {
                    this._bindControl();
                    this.bindTo(this._submit.domElem, 'pointerclick', this._onSubmit.bind(this));
                }
            }
        }
    },

    /**
     * При выборе варианта делаем кнопку активной
     * @private
     */
    _bindControl: function () {
        if (this._radiobox) {
            this._radiobox.on('change', this._enableButton.bind(this));
        } else if (this._checkboxes) {
            this._checkboxes.forEach(function (checkbox) {
                checkbox.on('change', this._onCheckBoxChange.bind(this));
            }.bind(this));
        }
    },

    /**
     * Обработчик нажатия на кнопку "Ответить"
     * @private
     */
    _onSubmit: function () {
        var successLevel = this._getSuccessLevel();

        this._submit.setMod('hidden', 'yes');
        this.setMod(this.findElem('success-indicator'), 'type', successLevel);
        this.delMod(this.findElem('explanation'), 'hidden');
        this.delMod(this.findElem('explanation-text', 'type', successLevel), 'hidden');

        if (this._radiobox) {
            this._radiobox.setMod('disabled', 'yes');
        } else if (this._checkboxes) {
            this._checkboxes.forEach(function (checkbox) {
                checkbox.setMod('disabled', 'yes');
            });
        }

        if (this.params.goalId) {
            BEM.blocks.metrika.reachGoal(this.params.goalId);
        }
    },

    /**
     * При выборе варианта делаем кнопку активной.
     * Если ни один вариант не выбран - делаем кнопку неактивной
     * @private
     */
    _onCheckBoxChange: function () {
        var checked = this._checkboxes.filter(function (checkbox) {
            return checkbox.isChecked();
        }).length > 0;

        if (checked) {
            this._enableButton();
        } else {
            this._disableButton();
        }
    },

    /**
     * Делает кнопку активной
     * @private
     */
    _enableButton: function () {
        this._submit.delMod('disabled');
    },

    /**
     * Делает кнопку неактивной
     * @private
     */
    _disableButton: function () {
        this._submit.setMod('disabled', 'yes');
    },

    /**
     * Восстанавливает ответы на тест из хранилища.
     * Возвращает true, если ответы найдены и восстановлены
     * @returns {Boolean}
     * @private
     */
    _recoverAnswers: function () {
        var savedAnswers = false;

        if (this._radiobox) {
            savedAnswers = this._recoverRadiobox();
        } else if (this._checkboxes) {
            savedAnswers = this._recoverCheckbox();
        }

        if (savedAnswers) {
            this._onSubmit();
        }

        return savedAnswers;
    },

    /**
     * Восстанавливает ответы в тесте с одним вариантом ответа
     * @returns {Boolean}
     * @private
     */
    _recoverRadiobox: function () {
        var savedAnswers = false;

        for (var idx = 0; idx < this._radioElems.length; idx += 1) {
            var $elem = $(this._radioElems[idx]);
            var radioId = $elem.attr('data-id');
            var value = $elem.attr('data-value');

            if (this._storage.get(radioId) === 'yes') {
                savedAnswers = true;
                this._radiobox.val(radioId);
                this.setMod(this.findElem($elem, 'option'), 'type', value);
            }
        }

        return savedAnswers;
    },

    /**
     * Восстанавилвает ответы в тесте с несколькими вариантами ответа
     * @returns {Boolean}
     * @private
     */
    _recoverCheckbox: function () {
        var savedAnswers = false;

        this._checkboxes.forEach(function (checkbox) {
            var $elem = $(checkbox.domElem);
            var option = this.findElem($elem, 'option');
            var checkboxId = $elem.attr('data-id');
            var type = $elem.attr('data-value');

            if (this._storage.get(checkboxId) === 'yes') {
                savedAnswers = true;
                checkbox.setMod('checked', 'yes');
                this.setMod(option, 'type', type);
            }
        }.bind(this));

        return savedAnswers;
    },

    /**
     * Определяет, насколько успешно пользователь ответил на вопрос
     * @private
     * @returns {'pass' | 'part' | 'fail'}
     */
    _getSuccessLevel: function () {
        if (this._radiobox) {
            return this._getRadioboxSuccessLevel();
        } else if (this._checkboxes.length) {
            return this._getCheckboxesSuccessLevel();
        }

        return 'pass';
    },

    /**
     * Возвращает степень правильности ответа пользователя для теста
     * с одним вариантом ответа
     * @returns {'pass' | 'part' | 'fail'}
     * @private
     */
    _getRadioboxSuccessLevel: function () {
        var checkedId = this._radiobox.val();
        var currentElem = this._radiobox.getCurrent();
        var value = currentElem.attr('data-value');

        if (checkedId) {
            this._storage.set(checkedId, 'yes');
            this.setMod(this.findElem(currentElem, 'option'), 'type', value);
        }

        this._markCorrectRadio();

        return value === 'correct' ? 'pass' : 'fail';
    },

    /**
     * Возвращает степень правильности ответа пользователя для теста
     * с несколькими вариантами ответа
     * @returns {'pass' | 'part' | 'fail'}
     * @private
     */
    _getCheckboxesSuccessLevel: function () {
        var items = this._checkboxes.reduce(function (acc, checkbox) {
            var $elem = $(checkbox.domElem);
            var option = this.findElem($elem, 'option');

            if (checkbox.val() === 'correct') {
                this.setMod(option, 'type', 'correct');
                acc.correct.push(checkbox);
            }

            if (checkbox.isChecked()) {
                this._storage.set($elem.attr('data-id'), 'yes');
                this.setMod(option, 'type', $elem.attr('data-value'));
                acc.checked.push(checkbox);
            }

            return acc;
        }.bind(this), { correct: [], checked: [] });

        var intersection = BEM.blocks['i-bem'].getIntersection(items.correct, items.checked);
        var interLen = intersection.length;

        if (interLen === 0) {
            return 'fail';
        } else if (interLen === items.correct.length && interLen === items.checked.length) {
            return 'pass';
        }

        return 'part';
    },

    /**
     * Помечает правильные варианты ответа
     * @private
     */
    _markCorrectOptions: function () {
        if (this._radiobox) {
            this._markCorrectRadio();
        } else if (this._checkboxes) {
            this._markCorrectCheckboxes();
        }
    },

    /**
     * Помечает правильный ответ в вопросе с одним вариантом ответа
     * @private
     */
    _markCorrectRadio: function () {
        for (var idx = 0; idx < this._radioElems.length; idx += 1) {
            var $elem = $(this._radioElems[idx]);
            var option = this.findElem($elem, 'option');
            var optionVal = $elem.attr('data-value');

            if (optionVal === 'correct') {
                this.setMod(option, 'type', optionVal);
                break;
            }
        }
    },

    /**
     * Помечает правильные ответы в вопросе
     * с несколькими правильными вариантами ответа
     * @private
     */
    _markCorrectCheckboxes: function () {
        this._checkboxes.forEach(function (checkbox) {
            var $elem = $(checkbox.domElem);
            var option = this.findElem($elem, 'option');
            var type = $elem.attr('data-value');

            if (type === 'correct') {
                this.setMod(option, 'type', 'correct');
            }
        }.bind(this));
    }
});
