module.exports = function (bh) {

    /**
     * Возвращает BEM-JSON для текстового элемента
     * @param {String} text
     * @returns {*|json}
     */
    function buildTabText(text) {
        return text && {
            elem: 'tab-text',
            mix: { block: 'html-content' },
            content: text
        };
    }

    bh.match('lesson-tabs', function (ctx, json) {
        var items = json.items;

        if (!items || items.length === 0) {
            return '';
        }

        ctx
            .js({ tabsId: json.tabsId })
            .content([
                {
                    elem: 'titles-wrapper',
                    content: {
                        elem: 'titles',
                        titles: items.map(function (item) {
                            return item.title;
                        })
                    }
                },
                {
                    elem: 'tabs',
                    tabs: items
                }
            ]);
    });

    bh.match('lesson-tabs__titles', function (ctx, json) {
        var titles = json.titles;

        ctx.content(titles.map(function (title, idx) {
            var isFirst = idx === 0;

            return {
                elem: 'tab-title',
                mods: { active: isFirst, index: idx },
                content: {
                    block: 'link',
                    mods: { theme: 'normal', visited: isFirst && 'yes' },
                    content: title
                }
            };
        }));
    });

    bh.match('lesson-tabs__tabs', function (ctx, json) {
        ctx.content(json.tabs.map(function (tab, idx) {
            return {
                elem: 'tab',
                mods: { hidden: idx > 0, index: idx },
                data: tab
            };
        }));
    });

    bh.match('lesson-tabs__tab', function (ctx, json) {
        var data = json.data;
        var title = data.title;
        var text = data.text;
        var image = data.image;
        var additionalText = data.additionalText;

        if (!text && !image && !additionalText) {
            return '';
        }

        ctx.content([
            buildTabText(text),
            image && {
                elem: 'tab-image',
                tag: 'img',
                attrs: {
                    alt: title,
                    title: title,
                    src: image
                }
            },
            buildTabText(additionalText)
        ]);
    });
};
