BEM.DOM.decl('lesson-tabs', {
    onSetMod: {
        js: {
            inited: function () {
                this._titles = this.elem('tab-title');
                this._tabs = this.elem('tab');
                this._storage = BEM.blocks['i-bem'].getStorage();

                this._recoverActiveTabs();
                this.bindTo(this._titles, 'pointerclick', this._onTitleClick.bind(this));
            }
        }
    },

    /**
     * Помечает посещённые табы
     * @private
     */
    _recoverActiveTabs: function () {
        for (var idx = 0; idx < this._titles.length; idx += 1) {
            var isStored = this._storage.get(this.params.tabsId + '-' + idx);

            if (isStored === 'yes') {
                var $title = $(this._titles[idx]);
                var link = this.findBlockInside($title, 'link');

                link.setMod('visited', 'yes');
            }
        }
    },

    /**
     * Обработчик клика по названию вкладки
     * @param {Object} e
     * @private
     */
    _onTitleClick: function (e) {
        var $title = e.data.domElem;
        var index = this.getMod($title, 'index');
        var activeTab = this.findElem('tab', 'index', index);
        var link = this.findBlockInside($title, 'link');

        this.delMod(this._titles, 'active');
        this.setMod($title, 'active', true);

        this.setMod(this._tabs, 'hidden', true);
        this.delMod(activeTab, 'hidden');

        this._storage.set(this.params.tabsId + '-' + index, 'yes');

        link.setMod('visited', 'yes');
    }
});
