module.exports = function (bh) {
    'use strict';

    /**
     * Оборачивает контент элемента image в image-wrapper
     * @param {String} imageType
     * @param {Object} content
     * @returns {Object}
     */
    function getImageContent(imageType, content) {
        return imageType === 'icon' ? {
            elem: 'image-wrapper',
            content: content
        } : content;
    }

    bh.match('level-card', function (ctx, json) {
        var link = json.link;
        var date = json.date;
        var url = link.url;
        var commentsData = json.commentsData;

        if (!url && link.prefix && link.slug) {
            url = bh.lib.util.placeholder('{s}/{s}', link.prefix, link.slug);
        }

        var commentsCountBlock = Boolean(commentsData) && {
            block: 'comments-count',
            type: json.commentsCounterType,
            commentsData: commentsData
        };

        ctx
            .tag('article')
            .content([
                {
                    elem: 'link',
                    linkColor: json.linkColor,
                    image: link.image,
                    imageType: link.imageType,
                    text: link.text,
                    fontSize: link.fontSize,
                    url: url
                },
                {
                    elem: 'additional',
                    additional: json.additional
                },
                {
                    elem: 'info',
                    content: [
                        {
                            elem: 'date',
                            content: date
                        },
                        commentsCountBlock
                    ]
                }
            ]);
    });

    bh.match('level-card__link', function (ctx, json) {
        var fontSize = json.fontSize || 'default';
        var imageType = json.imageType || 'image';

        ctx.content({
            block: 'link',
            mods: {
                theme: json.linkColor || 'black'
            },
            url: json.url,
            content: [
                json.image && {
                    block: 'level-card',
                    elem: 'image',
                    mods: { type: imageType },
                    src: json.image,
                    title: json.text,
                    imageType: imageType
                },
                {
                    block: 'level-card',
                    mods: { 'font-size': fontSize },
                    elem: 'text',
                    content: json.text
                }
            ]
        });
    });

    bh.match('level-card__image', function (ctx, json) {
        var title = bh.lib.util.replaceHtmlEntities(json.title);

        ctx.content(getImageContent(json.imageType, {
            tag: 'img',
            attrs: {
                src: ctx.tParam('mdsImage') || json.src,
                title: title,
                alt: title
            }
        }));
    });
};
