module.exports = function (bh) {
    'use strict';
    var overlayColors = {
        0: '#6159a9',
        1: '#5c8c9a',
        2: '#b1687f',
        3: '#68a7b1',
        4: '#343d46',
        5: '#e00000'
    };

    /* eslint-disable complexity */
    bh.match('level-image', function (ctx, json) {
        var level = json.level;
        var image = ctx.tParam('mdsImage');
        var isButtonEnabled = level.button && level.button.enabled;
        var buttonLink = level.button.link;
        var metrikaGoalId = level.button.metrikaGoalId;

        ctx
            .js(metrikaGoalId ? {
                metrikaGoalId: metrikaGoalId
            } : null)
            .mods({
                font: level.black && 'dark',
                background: image && 'image'
            })
            .attrs({
                style: image && 'background-image: url("' + image + '");'
            })
            .content([
                {
                    elem: 'base',
                    color: level.color,
                    opacity: level.opacity,
                    content: {
                        elem: 'content',
                        content: [
                            {
                                elem: 'text',
                                content: level.text
                            },
                            {
                                elem: 'description',
                                content: level.description
                            },
                            {
                                elem: 'button',
                                mods: { color: level.button.color },
                                button: level.button
                            }
                        ]
                    }
                },
                !isButtonEnabled && buttonLink && {
                    elem: 'banner',
                    url: buttonLink
                }
            ]);
    });
    /* eslint-enable complexity */

    bh.match('level-image__base', function (ctx, json) {
        if (!overlayColors[json.color]) {
            return;
        }

        var background = 'background-color:' + overlayColors[json.color];
        var opacity = 'opacity:' + parseFloat(json.opacity);

        ctx.content([
            {
                elem: 'overlay',
                attrs: { style: [background, opacity].join(';') }
            },
            ctx.content()
        ], true);
    });

    bh.match('level-image__button', function (ctx, json) {
        var button = json.button;

        if (!button.enabled) {
            return '';
        }

        ctx
            .tag('a')
            .attrs({
                href: button.link
            })
            .content([
                { elem: 'button-base' },
                {
                    elem: 'button-text',
                    content: button.text
                }
            ]);
    });

    bh.match('level-image__banner', function (ctx, json) {
        ctx
            .tag('a')
            .attrs({ href: json.url });
    });
};
