module.exports = function (bh) {
    bh.match('level-like', function (ctx, json) {
        var data = json.data;
        var text = data.text;
        var yesButton = data.yesButton;
        var noButton = data.noButton;

        ctx
            .js(true)
            .content([
                {
                    elem: 'text',
                    mix: { block: 'html-content' },
                    content: text
                },
                {
                    elem: 'button-group',
                    content: [
                        yesButton,
                        noButton
                    ]
                        .map(function (button) {
                            return {
                                elem: 'button',
                                data: button
                            };
                        })
                }
            ]);
    });

    bh.match('level-like__button', function (ctx, json) {
        var data = json.data;
        var type = data.type || 'like';
        var metrikaGoalId = data.metrikaGoalId;

        if (!data.enabled) {
            return '';
        }

        ctx
            .attrs({ 'data-goal': metrikaGoalId })
            .content({
                block: 'button2',
                mods: { theme: 'normal', size: 'm' },
                iconLeft: { mods: { type: type } },
                content: {
                    block: 'level-like',
                    elem: 'button-content',
                    content: [
                        {
                            elem: 'button-icon',
                            mods: { type: type },
                            content: {
                                block: 'icon',
                                mods: { type: 'like' }
                            }
                        },
                        {
                            elem: 'button-text',
                            content: data.text
                        }
                    ]
                }
            });
    });
};
