BEM.DOM.decl('level-like', {
    onSetMod: {
        js: {
            inited: function () {
                this._buttons = this.elem('button');

                this.bindTo(this._buttons, 'pointerclick', this._onButtonClick.bind(this));
            }
        }
    },

    _onButtonClick: function (e) {
        var target = e.data.domElem;
        var goalId = target.data('goal');

        for (var idx = 0; idx < this._buttons.length; idx += 1) {
            var button = this._buttons[idx];
            var icon = this.findBlockInside($(button), 'icon');

            icon.toggleMod('pressed', true, target[0] === button);
        }

        if (goalId) {
            BEM.blocks.metrika.reachGoal(goalId);
        }
    }
});
