BEM.DOM.decl('level-solution', {
    onSetMod: {
        js: {
            inited: function () {
                this._isFilterActivated = false;
                this._selectsNames = ['tasks', 'industries', 'products', 'companySize'];
                this._lockSelectChange = false;
                this._image = this.params.currentImage;
                this.__self.level = this;
                this.filter = this.params.defaultFilter;
                this._selects = this.findBlocksInside('select2');

                this._preloadImages();
                this._findElems();
                this._bindEvents();
            }
        },

        hidden: {
            yes: function () {
                if (!this._image) {
                    return;
                }

                setTimeout(function () {
                    this._setImage();
                    this.delMod('hidden');
                }.bind(this), 300);
            }
        }
    },

    /**
     * Предзагрузка изображений для индустрий
     * @private
     */
    _preloadImages: function () {
        var images = this.params.industries.map(function (industry) {
            return industry.image;
        });

        BEM.blocks['i-bem'].preloadImages(images);
    },

    /**
     * Находит и сохраняет селекты
     * @private
     */
    _findElems: function () {
        var filter = this.params.defaultFilter;

        this._selects = Object.keys(this.params)
            .filter(function (key) {
                return this._selectsNames.indexOf(key) > -1 && this.params[key].length;
            }, this)
            .map(function (name) {
                return this.findBlockInside({
                    block: 'select2',
                    modName: 'category',
                    modVal: name
                });
            }, this);

        this._allItems = this._selects
            .reduce(function (acc, select) {
                var menu = this.findBlockInside(select.popup.domElem, 'menu');
                var items = menu.elem('item');
                var $allItem = $(items[0]);
                var category = select.getMod('category');

                menu.setMod($allItem, 'icon', 'cross');

                if (filter.by !== category || filter.value === 'all') {
                    menu.setMod($allItem, 'hidden', 'yes');
                }

                acc[category] = {
                    menu: menu,
                    item: $allItem
                };

                return acc;
            }.bind(this), {});
    },

    /**
     * Подписывает селекты на событие `change`
     * @private
     */
    _bindEvents: function () {
        this._selects.forEach(function (select) {
            select.on('change', this._onSelectChange.bind(this, select));
        }, this);

        BEM.blocks.select2.on(this.domElem, 'change', function () {
            if (this._isFilterActivated) {
                return;
            }

            var section = this.params.section || 'main';

            BEM.blocks.metrika.reachGoal('solutions_filter_' + section);
            this._isFilterActivated = true;
        }.bind(this));
    },

    /* eslint-disable complexity */
    /**
     * Меняет изображение для текущей индустрии
     * @param {String} category
     * @param {String} value
     * @private
     */
    _changeImage: function (category, value) {
        if (category !== 'industries' || BH.lib.global.isMobile) {
            return;
        }

        var currentImage = this._image;
        var industry = BH.lib.findIndustry(this.params.industries, value);

        this._image = (industry && industry.image) || this.params.defaultImage;

        if (this.hasMod('image') && currentImage !== this._image) {
            this.setMod('hidden', 'yes');
        }
    },
    /* eslint-enable complexity */

    /**
     * Устанавливает изображение индустрии
     * @private
     */
    _setImage: function () {
        this.domElem.attr({
            style: 'background-image: url("' + this._image + '");'
        });
    },

    /**
     * Обработчик выбора нового значения селекта. Снимает выбор с
     * остальных селектов, кроме переданного, и отправляет запрос на сервер.
     * @param {jQuery} changedSelect
     * @private
     */
    _onSelectChange: function (changedSelect) {
        if (this._lockSelectChange) {
            return;
        }

        var category = changedSelect.getMod('category');
        var value = changedSelect.getVal() || 'all';

        var itemsData = this._allItems[category];
        var $allItem = itemsData.item;

        if (value === 'all') {
            var button = this.findBlockInside(changedSelect.domElem, 'button2');

            setTimeout(function () {
                button.setText(BH.lib.i18n('solutions', category));
            }, 1);
        }

        itemsData.menu.toggleMod($allItem, 'hidden', 'yes', '', value === 'all');

        this.filter = {
            by: category,
            value: value
        };

        this._changeUrl(category, value);
        this._uncheckSelects(category);
        this._changeImage(category, value);
        this._requestToServer(category, value);
    },

    /**
     * Снимает выделение с пунктов селектов, кроме
     * селектов с переданной категорией
     * @param {String} category
     * @private
     */
    _uncheckSelects: function (category) {
        this._lockSelectChange = true;

        try {
            this._selects.forEach(function (select) {
                if (select.getMod('category') !== category) {
                    select.setVal(null);
                }
            });

            Object.keys(this._allItems).forEach(function (key) {
                var itemsData = this._allItems[key];
                var $item = itemsData.item;

                if (key !== category && $item) {
                    itemsData.menu.setMod($item, 'hidden', 'yes');
                }
            }, this);
        } finally {
            this._lockSelectChange = false;
        }
    },

    /**
     * Меняет URL страницы
     * @param {String} category
     * @param {String} value
     * @private
     */
    _changeUrl: function (category, value) {
        var url = this.params.solutionsUrl;
        var section = this.params.section;
        var newUrl = '';

        if (section) {
            newUrl = BH.lib.util.placeholder('{s}/{s}?{s}={s}', url, section, category, value);
        } else {
            newUrl = BH.lib.util.placeholder('{s}?menu=open&{s}={s}', url, category, value);
        }

        var encodedUrl = encodeURI(newUrl);

        BEM.blocks['i-bem'].changeCurrentUrl(encodedUrl);
    },

    /**
     * Отправляет запрос на сервер.
     * @param {String} category
     * @param {String} value
     * @private
     */
    _requestToServer: function (category, value) {
        var requestOptions = {
            type: 'POST',
            url: this.params.filterUrl,
            contentType: 'application/json',
            data: JSON.stringify({
                startIdx: 0,
                section: this.params.section,
                filter: {
                    by: category,
                    value: value
                }
            })
        };

        BEM.blocks['solutions-list'].runSpinner();

        $.ajax(requestOptions)
            .done(this._changeSolutions.bind(this))
            .fail(this._showErrorMessage.bind(this));
    },

    /**
     * Заменяет решения на переданные.
     * @param {Object} data
     * @private
     */
    _changeSolutions: function (data) {
        if (Array.isArray(data.list)) {
            BEM.blocks['solutions-list']
                .setSolutions(data)
                .hideSpinner();
        } else {
            this._showErrorMessage();
        }
    },

    /**
     * Показывает сообщение об ошибке в случае некорректного ответа сервера.
     * @private
     */
    _showErrorMessage: function () {
        var failMessage = BH.lib.i18n('solutions', 'error');

        BEM.blocks['notifications-list'].notify(failMessage);
    }
}, {

    /**
     * Возвращает текущие настройки фильтрации
     * @returns {Object}
     */
    getFilter: function () {
        return this.level.filter;
    }
});
