module.exports = function (bh) {
    'use strict';

    bh.match('level-subscribe', function (ctx, json) {
        var caption = json.shareLevel.caption;

        ctx
            .tag('section')
            .js(true)
            .mix({
                block: 'level',
                mods: { type: 'share' }
            })
            .content([
                {
                    elem: 'wrapper',
                    mods: { caption: caption && 'yes' },
                    content: ctx.content()
                },
                caption && {
                    elem: 'caption',
                    content: caption
                }
            ], true);
    });

    bh.match('level-subscribe__button-container', function (ctx, json) {
        var buttons = [];
        var socialNetworks = Array.isArray(json.socialNetworks) ? json.socialNetworks : [];
        var networks = socialNetworks.filter(function (network) {
            return network.enabled;
        });

        networks.sort(function (network1, network2) {
            return network1.order - network2.order;
        });

        networks.forEach(function (network) {
            buttons.push(
                {
                    block: 'button',
                    attrs: {
                        style: network.icon && 'background-image: url("' + network.icon + '");'
                    },
                    mods: { type: 'social', social: network.name, size: 'xl', theme: 'clear' },
                    content: json.hasLable ? network.label : '',
                    url: network.url
                }
            );
        });

        ctx.content(buttons);
    });

    bh.match('level-subscribe__label', function (ctx) {
        ctx.tag('h3');
    });
};
