module.exports = function (blocks) {
    function getMod(type) {
        return (type === 'form' || type === 'all') ? type : 'single';
    }

    blocks.declare('level-subscribe', function (data) {
        var settings = data.shareLevel;
        var noSocials = false;
        var levelType = settings.type;

        if (levelType === 'no-socials') {
            noSocials = true;
            levelType = 'form';
        }

        if (!settings || settings.type === 'none') {
            return;
        }

        return {
            block: 'level-subscribe',
            mods: {
                type: getMod(levelType)
            },
            shareLevel: settings,
            noSocials: noSocials,
            enableMetrika: data.reachSubscribe
        };
    });
};
