module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('level_type_events', function (ctx, json) {
        var isMobile = bh.lib.global.isMobile;
        var eventsData = json.eventsData;
        var events = eventsData && eventsData.events;
        var eventSlugToUrl = eventsData && eventsData.eventSlugToUrl;
        var expertSlugToName = eventsData && eventsData.expertSlugToName;

        if (!events || !events.length) {
            return '';
        }

        ctx.content({
            elem: 'carousel-wrapper',
            content: events ? {
                block: 'owl-carousel',
                mods: { type: 'arrows' },
                js: {
                    options: {
                        responsive: isMobile && {
                            0: {
                                items: 1
                            },
                            300: {
                                items: 2
                            },
                            592: {
                                items: 3
                            },
                            882: {
                                items: 4
                            }
                        },
                        rewind: false,
                        nav: !isMobile,
                        loop: isMobile
                    }
                },
                content: [
                    events.map(function (event) {
                        var urlEvent = event.skipAnnouncement ?
                            event.registerButton.url : eventSlugToUrl[event.slug];

                        return {
                            block: 'event-card',
                            mods: { layout: 'line' },
                            event: event,
                            url: urlEvent,
                            expertSlugToName: expertSlugToName
                        };
                    }),
                    // Для того, чтобы последнее событие было видно
                    !isMobile && {
                        block: 'level',
                        elem: 'fake-event'
                    }
                ]
            } : null
        });
    });
    /* eslint-enable complexity */
};
