module.exports = function (bh) {
    bh.match('level_type_help', function (ctx, json) {
        ctx
            .tParam('newsPage', json.newsPage)
            .content(ctx.content(), true);
    });

    /* eslint-disable complexity */
    bh.match('level__item', function (ctx, json) {
        var item = json.item;
        var newsPage = ctx.tParam('newsPage');
        var slug = item && item.slug;
        var url = item && item.url;

        if (!url && newsPage && slug) {
            url = bh.lib.util.placeholder('{s}/{s}', newsPage, slug);
        }

        ctx.content(item && [
            {
                elem: 'text',
                content: {
                    block: 'link',
                    mods: { theme: 'black' },
                    url: url,
                    content: item.text
                }
            },
            {
                elem: 'help-theme',
                content: item.theme
            }
        ]);
    });
    /* eslint-enable complexity */
};
