module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('level_type_image3', function (ctx, json) {
        var level = json.level;
        var buttonText = level.buttonText;
        var goalId = level.metrikaGoalId;
        var image = bh.lib.util.mds(level.image, 'mainpage_image_d');

        ctx
            .js(goalId ? { goalId: goalId } : null)
            .tag(bh.lib.global.isMobile && buttonText ? 'div' : 'a')
            .attrs({
                href: level.link,
                style: image && 'background-image: url("' + image + '");'
            })
            .content([
                level.theme && {
                    elem: 'section',
                    mix: { elem: 'z-top' },
                    content: level.theme
                },
                (level.title || level.text) && {
                    elem: 'content',
                    content: [
                        level.title && {
                            elem: 'title',
                            mix: [
                                { block: 'html-content' },
                                { elem: 'z-top' }
                            ],
                            content: level.title
                        },
                        level.text && {
                            elem: 'text',
                            mix: [
                                { block: 'html-content' },
                                { elem: 'z-top' }
                            ],
                            content: level.text
                        },
                        buttonText && {
                            elem: 'button',
                            mods: { level: 'image3' },
                            mix: { elem: 'z-top' },
                            data: {
                                url: level.link,
                                text: buttonText
                            }
                        }
                    ]
                },
                { elem: 'overlay' }
            ]);
    });
    /* eslint-enable complexity */
};
